/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.agent;

import com.atlassian.bamboo.agent.AgentSecurityTokenService;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationPersister;
import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.plugins.web.conditions.RemoteAgentsManagableCondition;
import com.atlassian.bamboo.ww2.aware.ConditionallyAccessible;
import org.springframework.beans.factory.annotation.Autowired;

@ConditionallyAccessible(condition={RemoteAgentsManagableCondition.class})
public class ControlRemoteAgentsTokenVerification
extends GlobalAdminAction {
    @Autowired
    private AgentSecurityTokenService agentSecurityTokenService;
    @Autowired
    private AdministrationConfigurationPersister administrationConfigurationPersister;
    private boolean confirmed;
    private boolean enabling;

    public String enable() throws Exception {
        if (this.confirmed) {
            this.setSecurityTokenRequired(true);
            return "success";
        }
        this.enabling = true;
        return "input";
    }

    public String disable() throws Exception {
        if (this.confirmed) {
            this.setSecurityTokenRequired(false);
            return "success";
        }
        return "input";
    }

    private void setSecurityTokenRequired(boolean isRequired) {
        this.agentSecurityTokenService.resetSecurityToken();
        AdministrationConfiguration administrationConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration();
        administrationConfiguration.setSecurityTokenRequiredFromAgents(isRequired);
        this.administrationConfigurationPersister.saveAdministrationConfiguration(administrationConfiguration);
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    public boolean isEnabling() {
        return this.enabling;
    }
}

