/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.agent;

import com.atlassian.bamboo.agent.elastic.server.ElasticInstanceManager;
import com.atlassian.bamboo.buildqueue.manager.RemoteAgentManager;
import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.plugins.web.conditions.RemoteAgentsManagableCondition;
import com.atlassian.bamboo.ww2.aware.ConditionallyAccessible;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;

@ConditionallyAccessible(condition={RemoteAgentsManagableCondition.class})
public class ControlRemoteAgentsAvailability
extends GlobalAdminAction {
    private static final Logger log = Logger.getLogger(ControlRemoteAgentsAvailability.class);
    private boolean confirmed = false;
    private RemoteAgentManager remoteAgentManager;
    private ElasticInstanceManager elasticInstanceManager;

    public String enable() throws Exception {
        return this.setRemoteAgentFunctionEnabled(true);
    }

    public String disable() throws Exception {
        return this.confirmed ? this.setRemoteAgentFunctionEnabled(false) : "input";
    }

    private String setRemoteAgentFunctionEnabled(boolean enabled) {
        try {
            this.remoteAgentManager.setRemoteAgentFunctionEnabled(enabled);
        }
        catch (UnknownHostException e) {
            String message = this.getText("agent.remote.enablefunction.errorJMS");
            this.addActionError(message + "<br>UnknownHostException: " + e.getMessage());
            log.error((Object)message, (Throwable)e);
            return "error";
        }
        catch (Exception e) {
            String message = this.getText("agent.remote.enablefunction.error");
            this.addActionError(message + "<br>" + e.getMessage());
            log.error((Object)message, (Throwable)e);
            return "error";
        }
        return "success";
    }

    public int getNumberOfElasticInstancesRunning() {
        return this.elasticInstanceManager.getElasticRemoteAgents().size();
    }

    public void setRemoteAgentManager(RemoteAgentManager remoteAgentManager) {
        this.remoteAgentManager = remoteAgentManager;
    }

    public void setElasticAgentManager(ElasticInstanceManager elasticInstanceManager) {
        this.elasticInstanceManager = elasticInstanceManager;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }
}

