/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.agent;

import com.atlassian.bamboo.buildqueue.RemoteAgentAuthentication;
import com.atlassian.bamboo.buildqueue.RemoteAgentAuthentications;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.buildqueue.manager.RemoteAgentAuthenticationManager;
import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.plugins.web.conditions.RemoteAgentsManagableCondition;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.agent.BuildAgentFunctions;
import com.atlassian.bamboo.ww2.aware.ConditionallyAccessible;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.opensymphony.xwork2.Preparable;
import io.atlassian.fugue.Pair;
import java.util.List;
import java.util.UUID;
import org.apache.log4j.Logger;

@ConditionallyAccessible(condition={RemoteAgentsManagableCondition.class})
public class ControlRemoteAgentsAuthentication
extends GlobalAdminAction
implements Preparable {
    private static final Logger log = Logger.getLogger(ControlRemoteAgentsAuthentication.class);
    private boolean confirmed = false;
    private boolean isEnabling = false;
    private boolean autoApprove;
    private List<RemoteAgentAuthentication> approvedAuthentications;
    private Iterable<BuildAgent> onlineAgentsWithUuid;
    private List<Pair<UUID, String>> unapprovedOnlineAgents;
    private RemoteAgentAuthenticationManager authenticationManager;

    public void prepare() throws Exception {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (BuildAgent agent : this.onlineAgentsWithUuid) {
            RemoteAgentAuthentication existingAuthentication;
            UUID uuid = BuildAgentFunctions.getUuid((BuildAgent)agent);
            String ip = BuildAgentFunctions.getSystemInfo((BuildAgent)agent).getIpAddress();
            if (uuid == null || ip == null || (existingAuthentication = (RemoteAgentAuthentication)Iterables.find(this.approvedAuthentications, (Predicate)RemoteAgentAuthentications.matching((UUID)uuid, (String)ip), null)) != null) continue;
            builder.add((Object)Pair.pair((Object)uuid, (Object)ip));
        }
        this.unapprovedOnlineAgents = builder.build();
    }

    public String enable() throws Exception {
        this.isEnabling = true;
        return this.confirmed ? this.setRemoteAgentAuthenticationEnabled(true) : "input";
    }

    public String disable() throws Exception {
        return this.confirmed ? this.setRemoteAgentAuthenticationEnabled(false) : "input";
    }

    private String setRemoteAgentAuthenticationEnabled(boolean enabled) {
        try {
            this.authenticationManager.setRemoteAgentAuthenticationEnabled(enabled);
            if (this.isEnabling && this.autoApprove) {
                this.approveCurrentOnlineAgents();
            }
        }
        catch (Exception e) {
            String message = this.getText("agent.remote.authentication.enable.error");
            this.addActionError(message + "<br>" + e.getMessage());
            log.error((Object)message, (Throwable)e);
            return "error";
        }
        return "success";
    }

    private void approveCurrentOnlineAgents() {
        ImmutableList.Builder toApprove = ImmutableList.builder();
        for (Pair<UUID, String> unapprovedAgent : this.unapprovedOnlineAgents) {
            RemoteAgentAuthentication authentication = (RemoteAgentAuthentication)this.authenticationManager.getOrCreatePendingAuthentication((UUID)unapprovedAgent.left(), (String)unapprovedAgent.right(), null, false).getLeft();
            if (authentication.isApproved()) continue;
            toApprove.add((Object)authentication);
        }
        this.authenticationManager.approveAuthentications((Iterable)toApprove.build());
    }

    public int getUnapprovedOnlineAgentsCount() {
        return this.unapprovedOnlineAgents.size();
    }

    public boolean isEnabling() {
        return this.isEnabling;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    public void setAutoApprove(boolean autoApprove) {
        this.autoApprove = autoApprove;
    }

    public void setRemoteAgentAuthenticationManager(RemoteAgentAuthenticationManager remoteAgentManager) {
        this.authenticationManager = remoteAgentManager;
        this.approvedAuthentications = ImmutableList.copyOf((Iterable)this.authenticationManager.getAuthentications(RemoteAgentAuthentications.isApproved()));
    }

    public void setAgentManager(AgentManager agentManager) {
        this.onlineAgentsWithUuid = Iterables.filter((Iterable)agentManager.getAllRemoteAgents(true), (Predicate)Predicates.and((Predicate[])new Predicate[]{BuildAgentFunctions::isRemote, BuildAgentFunctions::hasUuid, BuildAgentFunctions::hasSystemInfo}));
    }
}

