/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.agent;

import com.atlassian.bamboo.configuration.agent.ConfigureSharedCapability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityScope;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.LocalCapabilitySet;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalAdminSecurityAware;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ConfigureSharedLocalCapability
extends ConfigureSharedCapability
implements GlobalAdminSecurityAware {
    private static final Logger log = Logger.getLogger(ConfigureSharedLocalCapability.class);
    private final Pattern allowedCharactersPattern = Pattern.compile("[\\p{Alpha}\\d:.]+");
    protected String builderKey;

    public void prepare() throws Exception {
        this.capabilitySet = this.capabilitySetManager.getSharedLocalCapabilitySet();
        if (this.capabilitySet == null) {
            this.capabilitySet = this.createSharedCapabilitySet();
        }
    }

    public void validate() {
        this.validateCapability();
    }

    @Override
    @NotNull
    protected CapabilitySet createSharedCapabilitySet() {
        return new LocalCapabilitySet(CapabilityScope.SHARED);
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    public String getBuilderKey() {
        return this.builderKey;
    }

    public void setBuilderKey(String builderKey) {
        if (!this.allowedCharactersPattern.matcher(builderKey).matches()) {
            throw new IllegalArgumentException();
        }
        this.builderKey = builderKey;
    }
}

