/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.agent;

import com.atlassian.bamboo.configuration.agent.CapabilityConfigurationSupport;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.util.ActionParamsUtils;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySource;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigureSharedCapability
extends CapabilityConfigurationSupport {
    private static final Logger log = Logger.getLogger(ConfigureSharedCapability.class);
    private String capabilityValue;
    private AuditLogService auditLogService;

    public String delete() {
        String sharedType = this.capabilitySet.getSharedCapabilitySetType();
        Capability capability = this.capabilitySet.getCapability(this.capabilityKey);
        if (sharedType != null && capability != null) {
            if (sharedType.equals("Local")) {
                this.auditLogService.log("Server Capability removed", capability.toString(), null, null);
            } else {
                this.auditLogService.log("Removed shared " + sharedType + " capability", capability.toString(), null, null);
            }
        }
        this.capabilitySet.removeCapability(this.capabilityKey);
        this.capabilitySetManager.saveCapabilitySet(this.capabilitySet);
        return "success";
    }

    public String add() throws Exception {
        return this.add(null);
    }

    public String add(@Nullable CapabilitySource capabilitySource) throws Exception {
        Capability capability = this.capabilityHelper.getCapabilityTypeFromTypeString(this.capabilityType).getCapability(ActionParamsUtils.getStringArrayMap());
        if (capabilitySource != null) {
            capability.setCapabilitySource(capabilitySource);
        }
        this.capabilitySet.addCapability(capability);
        this.capabilitySetManager.saveCapabilitySet(this.capabilitySet);
        String sharedType = this.capabilitySet.getSharedCapabilitySetType();
        if (sharedType != null) {
            if (sharedType.equals("Local")) {
                this.auditLogService.log("Server Capability added", null, capability.toString(), null);
            } else {
                this.auditLogService.log("Added shared " + sharedType + " capability", null, capability.toString(), null);
            }
        }
        this.getJsonObject().put("capability", (Object)this.capabilityHelper.buildCapabilityJsonObject(capability));
        return "success";
    }

    @NotNull
    protected abstract CapabilitySet createSharedCapabilitySet();

    public abstract boolean isLocal();

    public String getCapabilityValue() {
        return this.capabilityValue;
    }

    public void setCapabilityValue(String capabilityValue) {
        this.capabilityValue = capabilityValue;
    }

    public void setAuditLogService(AuditLogService auditLogService) {
        this.auditLogService = auditLogService;
    }
}

