/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.agent;

import com.atlassian.bamboo.buildqueue.RemoteAgentAuthentication;
import com.atlassian.bamboo.buildqueue.RemoteAgentAuthentications;
import com.atlassian.bamboo.buildqueue.manager.RemoteAgentAuthenticationManager;
import com.atlassian.bamboo.configuration.agent.AbstractRemoteAgentAuthenticationAction;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class ConfigureRemoteAgentAuthentications
extends AbstractRemoteAgentAuthenticationAction {
    private ImmutableList<RemoteAgentAuthentication> allAuthentications;
    private boolean isApprove;
    private String approveAction;
    private String revokeApprovalAction;
    private String[] selectedAuthentications;
    private String selectedSingleAuthentication;

    @Override
    public String doDefault() throws Exception {
        if (this.approveAction != null) {
            return this.approve();
        }
        if (this.revokeApprovalAction != null) {
            return this.revokeApproval();
        }
        this.addActionError(this.getText("agent.remote.authentication.action.actionNotSpecified"));
        return "error";
    }

    public String approve() {
        this.isApprove = true;
        List<RemoteAgentAuthentication> selected = this.selectedAuthentications();
        if (!selected.isEmpty() && !this.hasActionErrors()) {
            this.remoteAgentAuthenticationManager.approveAuthentications(selected);
        }
        return this.errorOrSuccess();
    }

    public String revokeApproval() {
        this.isApprove = false;
        List<RemoteAgentAuthentication> selected = this.selectedAuthentications();
        if (!selected.isEmpty() && !this.hasActionErrors()) {
            this.remoteAgentAuthenticationManager.revokeAgentAuthentications(selected);
        }
        return this.errorOrSuccess();
    }

    private String errorOrSuccess() {
        return this.hasActionErrors() ? "error" : "success";
    }

    private List<RemoteAgentAuthentication> selectedAuthentications() {
        ArrayList<RemoteAgentAuthentication> authentications = new ArrayList<RemoteAgentAuthentication>();
        if (this.selectedSingleAuthentication != null) {
            this.addIfNotNull(authentications, this.findByUuid(this.selectedSingleAuthentication));
        } else if (this.selectedAuthentications != null) {
            for (String uuid : this.selectedAuthentications) {
                this.addIfNotNull(authentications, this.findByUuid(uuid));
            }
        }
        return authentications;
    }

    private void addIfNotNull(List<RemoteAgentAuthentication> authentications, RemoteAgentAuthentication elem) {
        if (elem != null) {
            authentications.add(elem);
        }
    }

    @Override
    protected RemoteAgentAuthentication findAuthentication(UUID uuid) {
        ImmutableList allAuthsInOrder = this.isApprove ? this.allAuthentications : this.allAuthentications.reverse();
        return (RemoteAgentAuthentication)Iterables.find((Iterable)allAuthsInOrder, (Predicate)RemoteAgentAuthentications.matching((UUID)uuid), null);
    }

    public void setRemoteAgentAuthentications(String[] selectedAuthentications) {
        this.selectedAuthentications = selectedAuthentications;
    }

    public void setApprove(String approveAction) {
        this.approveAction = approveAction;
    }

    public void setRevokeApproval(String revokeApprovalAction) {
        this.revokeApprovalAction = revokeApprovalAction;
    }

    public void setAuthenticationUuid(String selectedSingleAuthentication) {
        this.selectedSingleAuthentication = selectedSingleAuthentication;
    }

    @Override
    public void setRemoteAgentAuthenticationManager(RemoteAgentAuthenticationManager remoteAgentAuthenticationManager) {
        super.setRemoteAgentAuthenticationManager(remoteAgentAuthenticationManager);
        this.allAuthentications = ImmutableList.copyOf((Iterable)remoteAgentAuthenticationManager.getAllAuthentications());
    }
}

