/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.agent;

import com.atlassian.bamboo.agent.AgentType;
import com.atlassian.bamboo.buildqueue.LocalAgentDefinition;
import com.atlassian.bamboo.configuration.agent.ConfigureAgentDetails;
import com.atlassian.bamboo.v2.build.agent.LocalBuildAgent;
import java.util.Collections;

public class ConfigureLocalAgentDetails
extends ConfigureAgentDetails {
    private static final int WAIT_SECONDS_FOR_STOP = 30;

    public String create() throws Exception {
        this.validateSave();
        if (this.hasActionErrors() || this.hasFieldErrors()) {
            return "error";
        }
        if (this.agent.getType() != AgentType.LOCAL) {
            this.addActionError("Cannot add a non-local agent.");
            return "error";
        }
        this.agent.setName(this.agentName);
        this.agent.setDescription(this.agentDescription);
        this.agentManager.createLocalAgent((LocalAgentDefinition)this.agent);
        return "success";
    }

    public String start() {
        LocalBuildAgent localBuildAgent = this.agentManager.getLocalAgent(this.agentId);
        if (localBuildAgent != null) {
            localBuildAgent.setRequestedToBeStopped(false);
            localBuildAgent.getExecutableBuildAgent().start();
            return "success";
        }
        this.addActionError(this.getText("agent.error.local.notFound", Collections.singletonList(String.valueOf(this.agentId))));
        return "error";
    }

    public String stop() throws Exception {
        LocalBuildAgent localBuildAgent = this.agentManager.getLocalAgent(this.agentId);
        if (localBuildAgent != null) {
            localBuildAgent.getExecutableBuildAgent().stop();
            localBuildAgent.getExecutableBuildAgent().waitForStop(30);
            return "success";
        }
        this.addActionError(this.getText("agent.error.local.notFound", Collections.singletonList(String.valueOf(this.agentId))));
        return "error";
    }
}

