/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.agent;

import com.atlassian.bamboo.agent.elastic.server.ElasticConfiguration;
import com.atlassian.bamboo.agent.elastic.server.ElasticFunctionalityFacade;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.capability.CapabilityConfiguratorPluginModule;
import com.atlassian.bamboo.capability.CapabilityDao;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.deployments.projects.persistence.RequirementDeploymentMapping;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plugin.descriptor.predicate.CapabilityConfiguratorEditPerspectiveEnabledModuleDescriptorPredicate;
import com.atlassian.bamboo.plugin.descriptor.predicate.CapabilityConfiguratorViewPerspectiveEnabledModuleDescriptorPredicate;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityAgentMapping;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityConfigurationManager;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityDecorator;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityElasticImageMapping;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityGroup;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityHelper;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityRequirementSetDecorator;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityType;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementImmutablePlanMapping;
import com.atlassian.bamboo.webwork.util.ActionParametersMapImpl;
import com.atlassian.struts.TextProvider;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.Preparable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureCapabilityKey
extends GlobalAdminAction
implements Preparable {
    private static final Logger log = Logger.getLogger(ConfigureCapabilityKey.class);
    protected String capabilityKey;
    protected List<CapabilityAgentMapping> capabilityAgentMappings;
    protected List<CapabilityElasticImageMapping> capabilityElasticImageMappings;
    protected List<RequirementImmutablePlanMapping> requirementPlanMappings;
    protected List<RequirementDeploymentMapping> requirementDeploymentEnvironmentMappings;
    protected CapabilityType capabilityType;
    protected CapabilityRequirementSetDecorator jobRequirementSetDecorator;
    protected CapabilityRequirementSetDecorator deploymentEnvironmentRequirementSetDecorator;
    protected CapabilityDecorator capability;
    protected Multimap<Capability, BuildAgent> capabilityAgentMappingsSorted;
    protected String parentUrl;
    protected String selectedTab;
    protected AgentManager agentManager;
    protected CapabilityDao capabilityDao;
    protected EnvironmentService environmentService;
    protected CapabilityHelper capabilityHelper;
    protected CapabilityConfigurationManager capabilityConfigurationManager;
    protected ElasticFunctionalityFacade elasticFunctionalityFacade;

    public void prepare() throws Exception {
        this.capabilityAgentMappings = this.capabilityDao.getCapabilitiesFromKey(this.capabilityKey);
        ElasticConfiguration elasticConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration().getElasticConfig();
        if (elasticConfiguration != null && elasticConfiguration.isEnabled()) {
            Comparator<ElasticImageConfiguration> imageConfigurationComparator = Comparator.comparing(ElasticImageConfiguration::getConfigurationName, String.CASE_INSENSITIVE_ORDER);
            this.capabilityElasticImageMappings = this.capabilityDao.getElasticImageCapabilitiesFromKey(elasticConfiguration.getRegion(), this.capabilityKey).stream().sorted(Comparator.comparing(CapabilityElasticImageMapping::getElasticImageConfiguration, imageConfigurationComparator)).collect(Collectors.toList());
        } else {
            this.capabilityElasticImageMappings = Collections.emptyList();
        }
        this.requirementPlanMappings = this.getRequirementsFromKey(this.capabilityKey);
        this.requirementDeploymentEnvironmentMappings = new ArrayList<RequirementDeploymentMapping>(this.environmentService.findEnvironmentsByRequirementKey(this.capabilityKey));
        Collections.sort(this.requirementPlanMappings);
        this.capabilityType = this.capabilityHelper.getCapabilityTypeFromKey(this.capabilityKey);
        this.jobRequirementSetDecorator = new CapabilityRequirementSetDecorator(this.requirementPlanMappings, (TextProvider)this, this.capabilityHelper);
        this.deploymentEnvironmentRequirementSetDecorator = new CapabilityRequirementSetDecorator(this.requirementDeploymentEnvironmentMappings, (TextProvider)this, this.capabilityHelper);
        this.capability = new CapabilityDecorator(this.capabilityKey, null, null, -1L, this.capabilityType, null, (com.opensymphony.xwork2.TextProvider)this, new CapabilityGroup(this.capabilityType, (com.opensymphony.xwork2.TextProvider)this), null);
        this.capabilityAgentMappingsSorted = LinkedListMultimap.create();
        LinkedHashMap<BuildAgent, Capability> reversedMapping = new LinkedHashMap<BuildAgent, Capability>();
        ArrayList<BuildAgent> agents = new ArrayList<BuildAgent>();
        for (CapabilityAgentMapping capabilityAgentMapping : this.capabilityAgentMappings) {
            Long agentId = capabilityAgentMapping.getAgentId();
            if (agentId != null) {
                BuildAgent agent = this.agentManager.getAgent(agentId.longValue());
                if (agent == null) continue;
                agents.add(agent);
                reversedMapping.put(agent, capabilityAgentMapping.getCapability());
                continue;
            }
            this.capabilityAgentMappingsSorted.put((Object)capabilityAgentMapping.getCapability(), null);
        }
        Collections.sort(agents, Comparators.getNameProviderCaseInsensitiveOrdering());
        for (BuildAgent agent : agents) {
            this.capabilityAgentMappingsSorted.put(reversedMapping.get(agent), (Object)agent);
        }
    }

    protected List<RequirementImmutablePlanMapping> getRequirementsFromKey(@NotNull String capabilityKey) {
        return this.capabilityDao.getImmutablePlansKeysByRequirementKey(capabilityKey).stream().map(p -> new RequirementImmutablePlanMapping(this.cachedPlanManager, (Requirement)p.getFirst(), (PlanKey)p.getSecond())).collect(Collectors.toList());
    }

    @Override
    public String doDefault() throws Exception {
        return "input";
    }

    public String update() throws Exception {
        ActionParametersMapImpl actionParameters = new ActionParametersMapImpl(ActionContext.getContext());
        Configuration capabilityConfiguration = this.capabilityConfigurationManager.getConfiguration(this.getCapabilityKey());
        Collection pluginModules = this.pluginAccessor.getModules((Predicate)new CapabilityConfiguratorViewPerspectiveEnabledModuleDescriptorPredicate(this.getCapabilityKey()));
        for (CapabilityConfiguratorPluginModule pluginModule : pluginModules) {
            pluginModule.customizeConfiguration(capabilityConfiguration, (ActionParametersMap)actionParameters);
        }
        this.capabilityConfigurationManager.setConfiguration(this.getCapabilityKey(), capabilityConfiguration);
        return "success";
    }

    public String getCapabilityTabId() {
        return this.capabilityHelper.getCapabilityTabForKey(this.capabilityKey);
    }

    public List<CapabilityAgentMapping> getCapabilityAgentMappings() {
        return this.capabilityAgentMappings;
    }

    public Collection<Map.Entry<Capability, BuildAgent>> getCapabilityAgentMappingsSorted() {
        return this.capabilityAgentMappingsSorted.entries();
    }

    public List<CapabilityElasticImageMapping> getCapabilityElasticImageMappings() {
        return this.capabilityElasticImageMappings;
    }

    public CapabilityType getCapabilityType() {
        return this.capabilityType;
    }

    public CapabilityRequirementSetDecorator getJobRequirementSetDecorator() {
        return this.jobRequirementSetDecorator;
    }

    public CapabilityRequirementSetDecorator getDeploymentEnvironmentRequirementSetDecorator() {
        return this.deploymentEnvironmentRequirementSetDecorator;
    }

    public CapabilityDecorator getCapability() {
        return this.capability;
    }

    @Nullable
    public BuildAgent getAgent(Long id) {
        return this.agentManager.getAgent(id.longValue());
    }

    public boolean getHasCapabilityConfiguratorPluginForEditPerspective() {
        Collection pluginModules = this.pluginAccessor.getModules((Predicate)new CapabilityConfiguratorEditPerspectiveEnabledModuleDescriptorPredicate(this.getCapabilityKey()));
        return CollectionUtils.isNotEmpty((Collection)pluginModules);
    }

    public List<String> getCapabilityConfiguratorPluginEditHtmlList() {
        ArrayList<String> htmlItems = new ArrayList<String>();
        Configuration capabilityConfiguration = this.capabilityConfigurationManager.getConfiguration(this.getCapabilityKey());
        Collection pluginModules = this.pluginAccessor.getModules((Predicate)new CapabilityConfiguratorEditPerspectiveEnabledModuleDescriptorPredicate(this.getCapabilityKey()));
        for (CapabilityConfiguratorPluginModule pluginModule : pluginModules) {
            String pluginHtml = pluginModule.getEditHtml(capabilityConfiguration);
            if (!StringUtils.isNotBlank((CharSequence)pluginHtml)) continue;
            htmlItems.add(pluginHtml);
        }
        return htmlItems;
    }

    public boolean getHasCapabilityConfiguratorPluginForViewPerspective() {
        Collection pluginModules = this.pluginAccessor.getModules((Predicate)new CapabilityConfiguratorViewPerspectiveEnabledModuleDescriptorPredicate(this.getCapabilityKey()));
        return CollectionUtils.isNotEmpty((Collection)pluginModules);
    }

    public List<String> getCapabilityConfiguratorPluginViewHtmlList() {
        ArrayList<String> htmlItems = new ArrayList<String>();
        Configuration capabilityConfiguration = this.capabilityConfigurationManager.getConfiguration(this.getCapabilityKey());
        Collection pluginModules = this.pluginAccessor.getModules((Predicate)new CapabilityConfiguratorViewPerspectiveEnabledModuleDescriptorPredicate(this.getCapabilityKey()));
        for (CapabilityConfiguratorPluginModule pluginModule : pluginModules) {
            String pluginHtml = pluginModule.getViewHtml(capabilityConfiguration);
            if (!StringUtils.isNotBlank((CharSequence)pluginHtml)) continue;
            htmlItems.add(pluginHtml);
        }
        return htmlItems;
    }

    public boolean isElasticBambooEnabled() {
        return this.elasticFunctionalityFacade.isElasticSupportEnabled();
    }

    public boolean isElasticSupportPossible() {
        return this.elasticFunctionalityFacade.isElasticSupportPossible((ErrorCollection)new SimpleErrorCollection());
    }

    public String getParentUrl() {
        return this.parentUrl;
    }

    public void setParentUrl(String parentUrl) {
        this.parentUrl = parentUrl;
    }

    public String getSelectedTab() {
        return this.selectedTab;
    }

    public void setSelectedTab(String selectedTab) {
        this.selectedTab = selectedTab;
    }

    public String getCapabilityKey() {
        return this.capabilityKey;
    }

    public void setCapabilityKey(String capabilityKey) {
        this.capabilityKey = capabilityKey;
    }

    public void setCapabilityDao(CapabilityDao capabilityDao) {
        this.capabilityDao = capabilityDao;
    }

    @Override
    public void setEnvironmentService(EnvironmentService environmentService) {
        this.environmentService = environmentService;
    }

    public void setCapabilityHelper(CapabilityHelper capabilityHelper) {
        this.capabilityHelper = capabilityHelper;
    }

    public void setAgentManager(AgentManager agentManager) {
        this.agentManager = agentManager;
    }

    public void setCapabilityConfigurationManager(CapabilityConfigurationManager capabilityConfigurationManager) {
        this.capabilityConfigurationManager = capabilityConfigurationManager;
    }

    public void setElasticFunctionalityFacade(ElasticFunctionalityFacade elasticFunctionalityFacade) {
        this.elasticFunctionalityFacade = elasticFunctionalityFacade;
    }
}

