/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.agent;

import com.atlassian.bamboo.buildqueue.PipelineDefinition;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.capability.CapabilityDao;
import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySetManager;
import com.opensymphony.xwork2.Preparable;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureCapability
extends GlobalAdminAction
implements Preparable {
    private static final Logger log = Logger.getLogger(ConfigureCapability.class);
    private Long capabilityId;
    private String value;
    private Capability capability;
    private CapabilitySetManager capabilitySetManager;
    private AgentManager agentManager;
    private CapabilityDao capabilityDao;

    public void prepare() throws Exception {
        if (this.capabilityId != null) {
            this.capability = this.capabilityDao.getCapability(this.capabilityId);
        }
    }

    public String doUpdate() throws Exception {
        this.capabilityDao.updateCapability(this.capabilityId, this.value);
        return "success";
    }

    public String remove() throws Exception {
        this.capabilityDao.removeCapability(this.capabilityId);
        return "success";
    }

    @Nullable
    public BuildAgent getAgentFromCapabilitySet(@NotNull CapabilitySet capabilitySet) {
        PipelineDefinition pipelineDefinition = this.capabilitySetManager.getPipelineDefinition(capabilitySet);
        return pipelineDefinition == null ? null : this.agentManager.getAgent(pipelineDefinition.getId());
    }

    public Long getCapabilityId() {
        return this.capabilityId;
    }

    public void setCapabilityId(Long capabilityId) {
        this.capabilityId = capabilityId;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Capability getCapability() {
        return this.capability;
    }

    public void setCapabilitySetManager(CapabilitySetManager capabilitySetManager) {
        this.capabilitySetManager = capabilitySetManager;
    }

    public void setAgentManager(AgentManager agentManager) {
        this.agentManager = agentManager;
    }

    public void setCapabilityDao(CapabilityDao capabilityDao) {
        this.capabilityDao = capabilityDao;
    }
}

