/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.agent;

import com.atlassian.bamboo.agent.AgentType;
import com.atlassian.bamboo.buildqueue.PipelineDefinition;
import com.atlassian.bamboo.configuration.agent.ViewAgents;
import com.atlassian.bamboo.event.AgentDisabledOrEnabledEvent;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.plugins.web.conditions.ManageAgentsPermissionCondition;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.ww2.aware.ConditionallyAccessible;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalAdminSecurityAware;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.Logger;

@ConditionallyAccessible(condition={ManageAgentsPermissionCondition.class})
public class ConfigureAgents
extends ViewAgents
implements GlobalAdminSecurityAware {
    private static final Logger log = Logger.getLogger(ConfigureAgents.class);
    private String enableButton;
    private String disableButton;
    private String deleteButton;
    private long[] visibleSelectedAgents;
    private boolean isCompleteContentSelected;
    private AuditLogService auditLogService;

    @Override
    public String doDefault() throws Exception {
        if (!this.isAllowedForRestrictedAdmin()) {
            return "restrictedAdminAccessDeniedError";
        }
        return super.doDefault();
    }

    public String reconfigure() throws Exception {
        boolean isDisableClicked;
        if (!this.isAllowedForRestrictedAdmin()) {
            return "restrictedAdminAccessDeniedError";
        }
        if (ArrayUtils.isEmpty((long[])this.getSelectedAgents())) {
            this.addActionError(this.getText("agent.error.notSelected"));
            this.validateInputKey();
            return "error";
        }
        boolean isDeleteClicked = this.deleteButton != null;
        boolean isEnableClicked = this.enableButton != null;
        boolean bl = isDisableClicked = this.disableButton != null;
        if (isEnableClicked || isDisableClicked) {
            this.setAgentsEnabledState(isEnableClicked);
        } else if (isDeleteClicked) {
            this.deleteAgents();
        } else {
            String text = this.getText("error.argument.illegal");
            this.addActionError(text);
            log.warn((Object)text);
            this.validateInputKey();
            return "error";
        }
        return super.doDefault();
    }

    private void deleteAgents() {
        for (long agentId : this.getSelectedAgents()) {
            if (!this.agentCanBeDeleted(agentId)) continue;
            try {
                this.agentManager.removeAgent(agentId);
            }
            catch (TimeoutException e) {
                String text = this.getText("agent.delete.error", Arrays.asList(agentId));
                this.addActionError(text);
                log.warn((Object)text, (Throwable)e);
            }
        }
    }

    private void setAgentsEnabledState(boolean shouldEnable) {
        for (long agentId : this.getSelectedAgents()) {
            BuildAgent buildAgent = this.agentManager.getAgent(agentId);
            if (buildAgent == null) {
                this.addActionError(this.getText("agent.error.notFound", Collections.singletonList(String.valueOf(agentId))));
                continue;
            }
            PipelineDefinition agent = buildAgent.getDefinition();
            if (agent.isEnabled() == shouldEnable) continue;
            agent.setEnabled(shouldEnable);
            this.agentManager.saveAnyPipeline(agent, AgentDisabledOrEnabledEvent::new);
            if (agent.isEnabled()) {
                this.auditLogService.log("Agent '" + agent.getName() + "' has been Enabled");
                continue;
            }
            this.auditLogService.log("Agent '" + agent.getName() + "' has been Disabled");
        }
    }

    private boolean agentCanBeDeleted(long agentId) {
        if (this.isCompleteContentSelected) {
            return true;
        }
        BuildAgent buildAgent = this.agentManager.getAgent(agentId);
        if (buildAgent == null) {
            this.addActionError(this.getText("agent.error.notFound", Collections.singletonList(String.valueOf(agentId))));
            return false;
        }
        if (buildAgent.getDefinition().getType() == AgentType.ELASTIC) {
            this.addActionError(this.getText("agent.error.agentIsElastic"));
            return false;
        }
        if (!buildAgent.getAgentStatus().isAllowDelete()) {
            this.addActionError(this.getText("agent.error.wrongState", Arrays.asList(buildAgent.getName(), buildAgent.getAgentStatus().toString())));
            return false;
        }
        return true;
    }

    public boolean isAllowedForRestrictedAdmin() {
        return true;
    }

    public String activateAll() throws Exception {
        this.agentManager.enableAllAgents();
        return "success";
    }

    public String deactivateAll() throws Exception {
        this.agentManager.disableAllAgents();
        return "success";
    }

    public String doRemoveAllRemoteAgents() throws Exception {
        ArrayList<Long> agentsToRemove = new ArrayList<Long>();
        for (BuildAgent buildAgent : this.agentManager.getAllRemoteAgents()) {
            agentsToRemove.add(buildAgent.getId());
        }
        for (Long aLong : agentsToRemove) {
            this.agentManager.removeAgent(aLong.longValue());
        }
        return "success";
    }

    private long[] getSelectedAgents() {
        if (!this.isCompleteContentSelected) {
            return this.visibleSelectedAgents;
        }
        List<BuildAgent> offlineAgents = this.getOfflineRemoteAgents();
        long[] offlineAgentIds = new long[this.getOfflineRemoteAgents().size()];
        int i = 0;
        for (BuildAgent offlineAgent : offlineAgents) {
            offlineAgentIds[i++] = offlineAgent.getId();
        }
        return offlineAgentIds;
    }

    public void setEnableButton(String enableButton) {
        this.enableButton = enableButton;
    }

    public void setDisableButton(String disableButton) {
        this.disableButton = disableButton;
    }

    public void setDeleteButton(String deleteButton) {
        this.deleteButton = deleteButton;
    }

    public void setSelectedAgents(long[] visibleSelectedAgents) {
        this.visibleSelectedAgents = visibleSelectedAgents;
    }

    public void setCompleteContentSelected(boolean completeContentSelected) {
        this.isCompleteContentSelected = completeContentSelected;
    }

    public void setAuditLogService(AuditLogService auditLogService) {
        this.auditLogService = auditLogService;
    }
}

