/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.agent;

import com.atlassian.bamboo.build.StopBuildManager;
import com.atlassian.bamboo.configuration.agent.ViewAgentDetails;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ConfigureAgentDetails
extends ViewAgentDetails {
    @Autowired
    private AuditLogService auditLogService;
    @Autowired
    private StopBuildManager stopBuildManager;

    protected void validateSave() {
        if (StringUtils.isBlank((CharSequence)this.agentName)) {
            this.addFieldError("agentName", this.getText("agent.error.required"));
        } else {
            for (BuildAgent buildAgent : this.agentManager.getAllAgents()) {
                if (!buildAgent.getDefinition().getName().equals(this.agentName) || buildAgent.getDefinition().getId() == this.agent.getId()) continue;
                this.addFieldError("agentName", this.getText("agent.error.duplicate"));
                break;
            }
            this.checkFieldXssSafety("agentName", this.agentName);
        }
    }

    public String save() throws Exception {
        this.validateSave();
        if (this.hasActionErrors() || this.hasFieldErrors()) {
            return "error";
        }
        this.agent.setName(this.agentName);
        this.agent.setDescription(this.agentDescription);
        this.agentManager.saveAnyPipeline(this.agent);
        return "success";
    }

    public String remove() throws Exception {
        this.agentManager.removeAgent(this.agentId);
        return "success";
    }

    public String stopNicely() throws Exception {
        if (this.buildAgent != null) {
            this.stopBuildManager.stopAgentNicely(this.buildAgent);
            return "success";
        }
        this.addActionError(this.getText("agent.error.notFound", Collections.singletonList(String.valueOf(this.agentId))));
        return "error";
    }

    public String enable() throws Exception {
        this.agent.setEnabled(true);
        this.agentManager.saveAnyPipeline(this.agent);
        this.auditLogService.log("Agent '" + this.agent.getName() + "' has been Enabled");
        return "success";
    }

    public String disable() throws Exception {
        this.agent.setEnabled(false);
        this.agentManager.saveAnyPipeline(this.agent);
        this.auditLogService.log("Agent '" + this.agent.getName() + "' has been Disabled");
        return "success";
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public void setAgentDescription(String agentDescription) {
        this.agentDescription = agentDescription;
    }
}

