/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.agent;

import com.atlassian.bamboo.buildqueue.ElasticAgentDefinition;
import com.atlassian.bamboo.buildqueue.LocalAgentDefinition;
import com.atlassian.bamboo.buildqueue.PipelineDefinition;
import com.atlassian.bamboo.buildqueue.PipelineDefinitionVisitor;
import com.atlassian.bamboo.buildqueue.RemoteAgentDefinition;
import com.atlassian.bamboo.buildqueue.manager.AgentCapabilityService;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.configuration.agent.CapabilityConfigurationSupport;
import com.atlassian.bamboo.util.ActionParamsUtils;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityRequirementSetDecorator;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.ReadOnlyCapabilitySet;
import com.atlassian.struts.TextProvider;
import javax.inject.Inject;

public class ConfigureAgentCapability
extends CapabilityConfigurationSupport {
    private CapabilitySet sharedCapabilitySet;
    private long agentId;
    protected PipelineDefinition agent;
    protected BuildAgent buildAgent;
    @Inject
    protected AgentManager agentManager;
    @Inject
    protected AgentCapabilityService agentCapabilityService;

    public void prepare() throws Exception {
        this.buildAgent = this.agentManager.getAgent(this.agentId);
        if (this.buildAgent != null) {
            this.agent = this.buildAgent.getDefinition();
            this.agent.accept(new PipelineDefinitionVisitor(){

                public void visitElastic(ElasticAgentDefinition pipelineDefinition) {
                }

                public void visitLocal(LocalAgentDefinition pipelineDefinition) {
                    ConfigureAgentCapability.this.capabilitySet = pipelineDefinition.getCapabilitySet();
                    ConfigureAgentCapability.this.sharedCapabilitySet = ConfigureAgentCapability.this.capabilitySetManager.getSharedLocalCapabilitySet();
                }

                public void visitRemote(RemoteAgentDefinition pipelineDefinition) {
                    ConfigureAgentCapability.this.capabilitySet = pipelineDefinition.getCapabilitySet();
                    ConfigureAgentCapability.this.sharedCapabilitySet = ConfigureAgentCapability.this.capabilitySetManager.getSharedRemoteCapabilitySet();
                }
            });
        }
    }

    public String doAddCapability() {
        if (!this.validateCapability()) {
            return "input";
        }
        Capability capability = this.capabilityHelper.getCapabilityTypeFromTypeString(this.capabilityType).getCapability(ActionParamsUtils.getStringArrayMap());
        ErrorCollection errorCollection = this.agentCapabilityService.addCapability(this.agent, capability.getKey(), capability.getValue());
        this.addErrorCollection(errorCollection);
        if (this.hasAnyErrors()) {
            return "input";
        }
        return "success";
    }

    public String doRemoveCapability() {
        if (this.capabilitySet == null) {
            return "success";
        }
        this.agentCapabilityService.removeCapability(this.agent, this.getCapabilityKey());
        return "success";
    }

    public CapabilityRequirementSetDecorator getSharedCapabilitySetDecorator() {
        return new CapabilityRequirementSetDecorator((ReadOnlyCapabilitySet)this.getSharedCapabilitySet(), null, (TextProvider)this, this.capabilityHelper);
    }

    @Override
    public CapabilitySet getSharedCapabilitySet() {
        return this.sharedCapabilitySet;
    }

    public void setSharedCapabilitySet(CapabilitySet sharedCapabilitySet) {
        this.sharedCapabilitySet = sharedCapabilitySet;
    }

    public long getAgentId() {
        return this.agentId;
    }

    public void setAgentId(long agentId) {
        this.agentId = agentId;
    }

    public PipelineDefinition getAgent() {
        return this.agent;
    }

    public void setAgent(PipelineDefinition agent) {
        this.agent = agent;
    }

    public BuildAgent getBuildAgent() {
        return this.buildAgent;
    }
}

