/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.agent;

import com.atlassian.bamboo.buildqueue.AgentAssignment;
import com.atlassian.bamboo.buildqueue.PipelineDefinition;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityRequirementsMatcher;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySetManager;
import com.atlassian.bamboo.v2.build.agent.capability.MinimalRequirementSet;
import com.atlassian.bamboo.v2.build.agent.capability.ReadOnlyCapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementSet;
import com.opensymphony.xwork2.Preparable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class ConfigureAgentAssignments
extends GlobalAdminAction
implements Preparable {
    private static final Logger log = Logger.getLogger(ConfigureAgentAssignments.class);
    private BuildAgent buildAgent;
    private PipelineDefinition agent;
    private long agentId;
    private CapabilitySet localSharedCapabilitySet;
    private CapabilitySet remoteSharedCapabilitySet;
    private AgentManager agentManager;
    @Autowired
    private EnvironmentService environmentService;
    private CapabilitySetManager capabilitySetManager;
    private CapabilityRequirementsMatcher capabilityRequirementsMatcher;

    public void prepare() throws Exception {
        this.buildAgent = this.agentManager.getAgent(this.agentId);
        if (this.buildAgent != null) {
            this.agent = this.buildAgent.getDefinition();
        } else {
            this.addActionError("Could not find a build agent with id " + this.agentId + " to edit");
        }
    }

    private boolean isCapabilitiesMatch(ReadOnlyCapabilitySet capabilitySet, long environmentId) {
        RequirementSet requirementSet = this.environmentService.getEnvironmentRequirementSet(environmentId);
        return this.capabilityRequirementsMatcher.matches(capabilitySet, (MinimalRequirementSet)requirementSet);
    }

    private CapabilitySet getLocalSharedCapabilitySet() {
        if (this.localSharedCapabilitySet == null) {
            this.localSharedCapabilitySet = this.capabilitySetManager.getSharedLocalCapabilitySet();
        }
        return this.localSharedCapabilitySet;
    }

    private CapabilitySet getRemoteSharedCapabilitySet() {
        if (this.remoteSharedCapabilitySet == null) {
            this.remoteSharedCapabilitySet = this.capabilitySetManager.getSharedRemoteCapabilitySet();
        }
        return this.remoteSharedCapabilitySet;
    }

    public long getAgentId() {
        return this.agentId;
    }

    public void setAgentId(long agentId) {
        this.agentId = agentId;
    }

    public PipelineDefinition getAgent() {
        return this.agent;
    }

    public List<AgentAssignment.ExecutableType> getAssignmentTypes() {
        return new ArrayList<AgentAssignment.ExecutableType>(Arrays.asList(AgentAssignment.ExecutableType.values()));
    }

    public void setAgentManager(AgentManager agentManager) {
        this.agentManager = agentManager;
    }

    public void setCapabilitySetManager(CapabilitySetManager capabilitySetManager) {
        this.capabilitySetManager = capabilitySetManager;
    }

    public void setCapabilityRequirementsMatcher(CapabilityRequirementsMatcher capabilityRequirementsMatcher) {
        this.capabilityRequirementsMatcher = capabilityRequirementsMatcher;
    }
}

