/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.agent;

import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.util.ActionParamsUtils;
import com.atlassian.bamboo.utils.ErrorCollectionUtils;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityDefaultsHelper;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityHelper;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityRequirementSetDecorator;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySetManager;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityType;
import com.atlassian.bamboo.v2.build.agent.capability.ReadOnlyCapabilitySet;
import com.atlassian.struts.TextProvider;
import com.atlassian.struts.ValidationAware;
import com.opensymphony.xwork2.Preparable;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class CapabilityConfigurationSupport
extends GlobalAdminAction
implements Preparable {
    private static final Logger log = Logger.getLogger(CapabilityConfigurationSupport.class);
    protected CapabilitySet capabilitySet;
    protected String capabilityKey;
    protected String capabilityType;
    protected String jdkLabel;
    protected String jdkPath;
    protected String builderLabel;
    protected String builderPath;
    @Autowired
    protected CapabilityHelper capabilityHelper;
    @Autowired
    protected CapabilitySetManager capabilitySetManager;
    @Autowired
    protected CapabilityDefaultsHelper capabilityDefaultsHelper;

    protected boolean validateCapability() {
        boolean valid = true;
        if (StringUtils.containsAny((CharSequence)this.capabilityKey, (CharSequence)"${}")) {
            this.addFieldError("capabilityKey", "Capability key cannot contain $, { or } character");
            valid = false;
        }
        if (this.capabilityType != null) {
            CapabilityType capabilityType = this.capabilityHelper.getCapabilityTypeFromTypeString(this.capabilityType);
            if (capabilityType != null) {
                Map capabilityValidationErrors = capabilityType.validate(ActionParamsUtils.getStringArrayMap());
                ErrorCollectionUtils.addFieldErrors((ValidationAware)this, (Map)capabilityValidationErrors);
                valid &= capabilityValidationErrors.isEmpty();
            } else {
                this.addActionError("Unknown capability type was specified.");
                valid = false;
            }
        } else {
            this.addActionError("No capability type was specified.");
            valid = false;
        }
        return valid;
    }

    public CapabilityRequirementSetDecorator getCapabilitySetDecorator() {
        return new CapabilityRequirementSetDecorator((ReadOnlyCapabilitySet)this.getCapabilitySet(), (ReadOnlyCapabilitySet)this.getSharedCapabilitySet(), (TextProvider)this, this.capabilityHelper);
    }

    public String getCapabilityType(Capability capability) {
        String key = capability.getKey();
        return this.capabilityHelper.getCapabilityType(key);
    }

    public Collection<CapabilityType> getCapabilityTypes() {
        return this.capabilityHelper.getCapabilityTypes();
    }

    @Nullable
    public CapabilitySet getSharedCapabilitySet() {
        return null;
    }

    public String getCapabilityKey() {
        return this.capabilityKey;
    }

    public void setCapabilityKey(String capabilityKey) {
        this.capabilityKey = capabilityKey;
    }

    public String getCapabilityType() {
        return this.capabilityType;
    }

    public void setCapabilityType(String capabilityType) {
        this.capabilityType = capabilityType;
    }

    public CapabilityHelper getCapabilityHelper() {
        return this.capabilityHelper;
    }

    public String getJdkLabel() {
        return this.jdkLabel;
    }

    public void setJdkLabel(String jdkLabel) {
        this.jdkLabel = jdkLabel;
    }

    public String getJdkPath() {
        return this.jdkPath;
    }

    public void setJdkPath(String jdkPath) {
        this.jdkPath = jdkPath;
    }

    public String getBuilderLabel() {
        return this.builderLabel;
    }

    public void setBuilderLabel(String builderLabel) {
        this.builderLabel = builderLabel;
    }

    public String getBuilderPath() {
        return this.builderPath;
    }

    public void setBuilderPath(String builderPath) {
        this.builderPath = builderPath;
    }

    public CapabilitySet getCapabilitySet() {
        return this.capabilitySet;
    }

    public void setCapabilitySet(CapabilitySet capabilitySet) {
        this.capabilitySet = capabilitySet;
    }
}

