/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.agent;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.net.InetAddresses;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class AtlassianProxyIpList {
    private static final Logger log = Logger.getLogger(AtlassianProxyIpList.class);
    private static final ImmutableList<IpRange> ATLASSIAN_PROXY_IP_RANGES = ImmutableList.of((Object)IpRange.of("59.167.29.217", 32), (Object)IpRange.of("104.192.140.0", 23), (Object)IpRange.of("131.103.26.0", 23), (Object)IpRange.of("131.103.28.0", 24), (Object)IpRange.of("131.103.29.0", 24), (Object)IpRange.of("165.254.226.0", 23));
    private static final LoadingCache<InetAddress, Boolean> ATLASSIAN_PROXY_IP_CACHE = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).maximumSize(1000L).build(CacheLoader.from(inetAddress -> ATLASSIAN_PROXY_IP_RANGES.stream().anyMatch(atlassianProxyIpRange -> atlassianProxyIpRange.addressInRange((InetAddress)inetAddress))));

    public static boolean isAtlassianProxyIp(@NotNull String ip) {
        try {
            return AtlassianProxyIpList.isAtlassianProxyIp(InetAddresses.forString((String)ip.trim()));
        }
        catch (IllegalArgumentException e) {
            log.debug((Object)("Invalid IP address:" + ip));
            return false;
        }
    }

    public static boolean isAtlassianProxyIp(@NotNull InetAddress inetAddress) {
        return (Boolean)ATLASSIAN_PROXY_IP_CACHE.getUnchecked((Object)inetAddress);
    }

    @NotNull
    public static String removeAtlassianProxyFromIpString(@NotNull String ipString) {
        return Arrays.stream(ipString.split(",")).map(String::trim).filter(ip -> !AtlassianProxyIpList.isAtlassianProxyIp(ip)).collect(Collectors.joining(","));
    }

    @VisibleForTesting
    protected static class IpRange {
        final int low;
        final int mask;

        public IpRange(@NotNull String low, int bits) {
            this.low = InetAddresses.coerceToInteger((InetAddress)InetAddresses.forString((String)low));
            this.mask = -1 << 32 - bits;
        }

        public static IpRange of(@NotNull String low, int bits) {
            return new IpRange(low, bits);
        }

        public boolean addressInRange(@NotNull InetAddress inetAddress) {
            if (inetAddress instanceof Inet6Address) {
                return false;
            }
            int intAddress = InetAddresses.coerceToInteger((InetAddress)inetAddress);
            return this.low == (intAddress & this.mask);
        }
    }
}

