/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.agent;

import com.atlassian.bamboo.buildqueue.RemoteAgentAuthentication;
import com.atlassian.bamboo.buildqueue.manager.RemoteAgentAuthenticationManager;
import com.atlassian.bamboo.configuration.GlobalAdminAction;
import java.util.UUID;

public class AbstractRemoteAgentAuthenticationAction
extends GlobalAdminAction {
    protected RemoteAgentAuthenticationManager remoteAgentAuthenticationManager;

    protected RemoteAgentAuthentication findByUuid(String uuid) {
        UUID parsedUuid = this.safeParse(uuid);
        if (parsedUuid == null) {
            return null;
        }
        RemoteAgentAuthentication authentication = this.findAuthentication(parsedUuid);
        if (authentication == null) {
            this.onAuthenticationNotFound(uuid, parsedUuid);
        }
        return authentication;
    }

    protected UUID safeParse(String uuid) {
        try {
            return UUID.fromString(uuid);
        }
        catch (IllegalArgumentException wrongUuid) {
            this.addActionError(this.getText("agent.remote.authentication.action.uuidError", new String[]{uuid}));
            return null;
        }
    }

    protected void onAuthenticationNotFound(String uuid, UUID parsedUuid) {
        this.addActionMessage(this.getText("agent.remote.authentication.action.authenticationNotFound", new String[]{uuid}));
    }

    protected RemoteAgentAuthentication findAuthentication(UUID uuid) {
        return this.remoteAgentAuthenticationManager.getAuthentication(uuid);
    }

    public void setRemoteAgentAuthenticationManager(RemoteAgentAuthenticationManager remoteAgentAuthenticationManager) {
        this.remoteAgentAuthenticationManager = remoteAgentAuthenticationManager;
    }
}

