/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration;

import com.atlassian.bamboo.filter.Pager;
import com.atlassian.bamboo.persister.AuditLogEntry;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.aware.LazyPaginationAware;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalAdminSecurityAware;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ViewGlobalAuditLogAction
extends BambooActionSupport
implements GlobalAdminSecurityAware,
LazyPaginationAware<AuditLogEntry> {
    private Pager pager;
    private AuditLogService auditLogService;
    private static final Logger log = Logger.getLogger(ViewGlobalAuditLogAction.class);

    public String delete() {
        try {
            this.auditLogService.removeGlobalAuditLogMessages();
        }
        catch (Exception e) {
            log.error((Object)e.toString());
            log.debug(null, (Throwable)e);
            this.addActionError("Failed to delete plan audit logs ");
            return "error";
        }
        return "success";
    }

    public String deleteAll() {
        try {
            this.auditLogService.removeAllAuditLogMessages();
        }
        catch (Exception e) {
            log.error((Object)e.toString());
            log.debug(null, (Throwable)e);
            this.addActionError("Failed to delete all audit logs ");
            return "error";
        }
        return "success";
    }

    public String enable() {
        this.auditLogService.setEnabled(true);
        return "success";
    }

    public String disable() {
        this.auditLogService.setEnabled(false);
        return "success";
    }

    public boolean isEnabled() {
        return this.auditLogService.isEnabled();
    }

    @Override
    public Pager<AuditLogEntry> getPager() {
        return this.pager;
    }

    @Override
    public void setPager(Pager<AuditLogEntry> pager) {
        this.pager = pager;
    }

    @Override
    @NotNull
    public List<AuditLogEntry> getFilteredResultsList(int firstResult, int maxResults) {
        return this.auditLogService.getGlobalAuditLogMessages(firstResult, maxResults);
    }

    @Override
    public int getResultsCount() {
        return (int)this.auditLogService.countGlobalAuditLogMessages();
    }

    public void setAuditLogService(AuditLogService auditLogService) {
        this.auditLogService = auditLogService;
    }
}

