/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration;

import com.atlassian.bamboo.amq.BambooBrokerService;
import com.atlassian.bamboo.configuration.SystemInfo;
import com.atlassian.bamboo.configuration.SystemStatisticsBean;
import com.atlassian.bamboo.security.GlobalApplicationSecureObject;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalAdminSecurityAware;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.github.ziplet.filter.compression.statistics.CompressingFilterStats;
import com.github.ziplet.filter.compression.statistics.CompressingFilterStatsImpl;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import org.apache.activemq.broker.TransportConnector;
import org.apache.struts2.util.ServletContextAware;
import org.springframework.beans.factory.annotation.Autowired;

public class SystemInfoAction
extends BambooActionSupport
implements GlobalAdminSecurityAware,
ServletContextAware {
    private SystemInfo systemInfo;
    private SystemStatisticsBean systemStatisticsBean;
    private ServletContext servletContext;
    private PluginAccessor pluginAccessor;
    private List<Plugin> enabledPlugins;
    @Autowired
    private BambooBrokerService brokerService;

    public String execute() throws Exception {
        return "success";
    }

    public Date getBambooBuildDate() {
        return BuildUtils.getCurrentBuildDate();
    }

    public String getBambooBuildNumber() {
        return BuildUtils.getCurrentBuildNumber();
    }

    public String getBambooVersion() {
        return BuildUtils.getCurrentVersion();
    }

    public SystemInfo getSystemInfo() {
        return this.systemInfo;
    }

    public List<TransportConnector> getTransportConnectors() {
        return this.brokerService.getTransportConnectors();
    }

    public void setSystemInfo(SystemInfo systemInfo) {
        this.systemInfo = systemInfo;
    }

    public Collection<Plugin> getEnabledPlugins() {
        if (this.enabledPlugins == null) {
            this.enabledPlugins = this.pluginAccessor.getEnabledPlugins().stream().sorted(Comparator.comparing(Plugin::getName, Comparator.nullsLast(Comparator.naturalOrder()))).collect(Collectors.toList());
        }
        return this.enabledPlugins;
    }

    public SystemStatisticsBean getSystemStatisticsBean() {
        return this.systemStatisticsBean;
    }

    public void setSystemStatisticsBean(SystemStatisticsBean systemStatisticsBean) {
        this.systemStatisticsBean = systemStatisticsBean;
    }

    @Override
    public Object getSecuredDomainObject() {
        return GlobalApplicationSecureObject.INSTANCE;
    }

    public CompressingFilterStats getCompressionStats() {
        String statsKey = new CompressingFilterStatsImpl().getStatsKey();
        return (CompressingFilterStats)this.getServletContext().getAttribute(statsKey);
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }
}

