/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration;

import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalAdminSecurityAware;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Sets;
import com.zaxxer.hikari.HikariPoolMXBean;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.activemq.broker.jmx.BrokerViewMBean;
import org.apache.activemq.broker.jmx.MBeanInfo;
import org.apache.activemq.broker.jmx.ProducerViewMBean;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.broker.jmx.SubscriptionViewMBean;
import org.apache.activemq.broker.jmx.TopicViewMBean;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.log4j.Logger;

public class PerformanceStatsJmxAction
extends BambooActionSupport
implements GlobalAdminSecurityAware {
    private static final Logger log = Logger.getLogger(PerformanceStatsJmxAction.class);
    private static final String JMX_URL = "service:jmx:rmi:///jndi/rmi://:1099/jmxrmi";
    private static final String TYPE_PROPERTY_NAME = "Type";
    public static final Comparator<ObjectInstance> COMPARE_BY_TYPE = new Comparator<ObjectInstance>(){

        @Override
        public int compare(ObjectInstance o1, ObjectInstance o2) {
            String type2;
            String type1 = o1.getObjectName().getKeyProperty(PerformanceStatsJmxAction.TYPE_PROPERTY_NAME);
            int compareType = ObjectUtils.compare((Comparable)((Object)type1), (Comparable)((Object)(type2 = o2.getObjectName().getKeyProperty(PerformanceStatsJmxAction.TYPE_PROPERTY_NAME))));
            if (compareType != 0) {
                return compareType;
            }
            return ObjectUtils.compare((Comparable)o1.getObjectName(), (Comparable)o2.getObjectName());
        }
    };
    private ConcurrentMap<String, Set<ObjectInstance>> objectInstancesByClass;
    private MBeanServerConnection mbsc;
    private static final Predicate<Method> IS_GETTER_FOR_PRIMITIVE_OR_STRING = new Predicate<Method>(){

        public boolean apply(Method method) {
            return method.getName().startsWith("get") && !method.getReturnType().isArray() && (method.getReturnType().isPrimitive() || method.getReturnType().equals(String.class));
        }
    };
    private boolean isJmxConnectionPresent = false;

    public PerformanceStatsJmxAction() {
        LoadingCache objectInstanceCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Set<ObjectInstance>>(){

            public Set<ObjectInstance> load(String key) throws Exception {
                return Sets.newTreeSet(COMPARE_BY_TYPE);
            }
        });
        try {
            JMXServiceURL url = new JMXServiceURL(JMX_URL);
            JMXConnector jmxc = JMXConnectorFactory.connect(url, null);
            this.mbsc = jmxc.getMBeanServerConnection();
        }
        catch (MalformedURLException e) {
            log.warn((Object)"Unable to connect to service:jmx:rmi:///jndi/rmi://:1099/jmxrmi", (Throwable)e);
            return;
        }
        catch (IOException e) {
            log.warn((Object)"Unable to get connection to MBean server", (Throwable)e);
            return;
        }
        try {
            Set<ObjectInstance> activeMqObjectInstances = this.mbsc.queryMBeans(new ObjectName("org.apache.activemq:*"), null);
            for (ObjectInstance activeMqObjectInstance : activeMqObjectInstances) {
                ((Set)objectInstanceCache.getUnchecked((Object)activeMqObjectInstance.getClassName())).add(activeMqObjectInstance);
            }
            this.objectInstancesByClass = objectInstanceCache.asMap();
        }
        catch (IOException e) {
            log.warn((Object)"Unable to fetch ActiveMQ MBeans list", (Throwable)e);
            return;
        }
        catch (MalformedObjectNameException e) {
            log.warn((Object)"", (Throwable)e);
            return;
        }
        this.isJmxConnectionPresent = true;
    }

    public List<List<String>> getQueueStats() {
        return this.getMbeanStatsTable("org.apache.activemq.broker.jmx.QueueView", QueueViewMBean.class, IS_GETTER_FOR_PRIMITIVE_OR_STRING);
    }

    public List<List<String>> getTopicStats() {
        return this.getMbeanStatsTable("org.apache.activemq.broker.jmx.TopicView", TopicViewMBean.class, IS_GETTER_FOR_PRIMITIVE_OR_STRING);
    }

    public List<List<String>> getProducerStats() {
        return this.getMbeanStatsTable("org.apache.activemq.broker.jmx.ProducerView", ProducerViewMBean.class, IS_GETTER_FOR_PRIMITIVE_OR_STRING);
    }

    public List<List<String>> getSubscriberStats() {
        return this.getMbeanStatsTable("org.apache.activemq.broker.jmx.SubscriptionView", SubscriptionViewMBean.class, IS_GETTER_FOR_PRIMITIVE_OR_STRING);
    }

    public List<List<String>> getTopicSubscriberStats() {
        return this.getMbeanStatsTable("org.apache.activemq.broker.jmx.TopicSubscriptionView", SubscriptionViewMBean.class, IS_GETTER_FOR_PRIMITIVE_OR_STRING);
    }

    public List<Pair<String, List<Pair<String, String>>>> getBrokerStats() {
        return this.getMbeanStats("org.apache.activemq.broker.jmx.BrokerView", BrokerViewMBean.class, IS_GETTER_FOR_PRIMITIVE_OR_STRING);
    }

    public Set<String> getRemainingJmxObjects() throws MalformedObjectNameException, SQLException {
        return this.objectInstancesByClass.keySet();
    }

    private <T> List<List<String>> getMbeanStatsTable(String className, Class<T> mbeanInterface, Predicate<Method> methodPredicate) {
        Method[] methods;
        ArrayList<List<String>> tableRows = new ArrayList<List<String>>();
        Set allMbeansOfType = (Set)this.objectInstancesByClass.remove(className);
        for (Method method : methods = mbeanInterface.getMethods()) {
            if (!methodPredicate.apply((Object)method) || method.getParameterTypes().length != 0) continue;
            ArrayList<String> row = new ArrayList<String>();
            String description = method.getAnnotation(MBeanInfo.class).value();
            row.add(description);
            for (ObjectInstance mbean : allMbeansOfType) {
                T mbeanProxy = JMX.newMBeanProxy(this.mbsc, mbean.getObjectName(), mbeanInterface);
                try {
                    Object value = method.invoke(mbeanProxy, new Object[0]);
                    row.add(value.toString());
                }
                catch (Exception exception) {}
            }
            tableRows.add(row);
        }
        return tableRows;
    }

    private <T> List<Pair<String, List<Pair<String, String>>>> getMbeanStats(String className, Class<T> mbeanInterface, Predicate<Method> methodPredicate) {
        ArrayList<Pair<String, List<Pair<String, String>>>> allStatPairs = new ArrayList<Pair<String, List<Pair<String, String>>>>();
        Set allMbeansOfType = (Set)this.objectInstancesByClass.remove(className);
        for (ObjectInstance mbean : allMbeansOfType) {
            Method[] methods;
            ArrayList<Pair> statPairs = new ArrayList<Pair>();
            T mbeanProxy = JMX.newMBeanProxy(this.mbsc, mbean.getObjectName(), mbeanInterface);
            for (Method method : methods = mbeanInterface.getMethods()) {
                if (!methodPredicate.apply((Object)method) || method.getParameterTypes().length != 0) continue;
                try {
                    Object value = method.invoke(mbeanProxy, new Object[0]);
                    MBeanInfo annotation = method.getAnnotation(MBeanInfo.class);
                    String description = annotation == null ? method.getName() : annotation.value();
                    statPairs.add(Pair.make((Object)description, (Object)value.toString()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            allStatPairs.add((Pair<String, List<Pair<String, String>>>)Pair.make((Object)mbean.getObjectName().toString(), statPairs));
        }
        return allStatPairs;
    }

    public List<Pair<String, String>> getHikariStats() {
        try {
            return PerformanceStatsJmxAction.hikari(this.mbsc);
        }
        catch (MalformedObjectNameException e) {
            log.warn((Object)"", (Throwable)e);
            return new ArrayList<Pair<String, String>>();
        }
    }

    public boolean isJmxConnectionPresent() {
        return this.isJmxConnectionPresent;
    }

    private static List<Pair<String, String>> hikari(MBeanServerConnection mbsc) throws MalformedObjectNameException {
        ObjectName mbeanName = new ObjectName("com.zaxxer.hikari:type=Pool (HikariPool-2)");
        HikariPoolMXBean mbeanProxy = JMX.newMBeanProxy(mbsc, mbeanName, HikariPoolMXBean.class);
        ArrayList<Pair<String, String>> hikariStats = new ArrayList<Pair<String, String>>();
        PerformanceStatsJmxAction.add(hikariStats, "Connections", mbeanProxy.getTotalConnections());
        PerformanceStatsJmxAction.add(hikariStats, "Busy Connections", mbeanProxy.getActiveConnections());
        PerformanceStatsJmxAction.add(hikariStats, "Idle Connections", mbeanProxy.getIdleConnections());
        PerformanceStatsJmxAction.add(hikariStats, "Threads awaiting checkout", mbeanProxy.getThreadsAwaitingConnection());
        return hikariStats;
    }

    private static void add(List<Pair<String, String>> stats, String name, int value) {
        stats.add((Pair<String, String>)Pair.make((Object)name, (Object)String.valueOf(value)));
    }
}

