/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration;

import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.configuration.ManualEncryptionConfiguration;
import com.atlassian.bamboo.configuration.RssSecurityConfiguration;
import com.atlassian.bamboo.configuration.SerializationSecurityConfig;
import com.atlassian.bamboo.configuration.SerializationSecurityMethod;
import com.atlassian.bamboo.docker.BambooDockerHelper;
import com.atlassian.bamboo.event.SecuritySettingsUpdatedEvent;
import com.atlassian.bamboo.repository.NameValuePair;
import com.atlassian.bamboo.security.GlobalPermissionsService;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.security.acegi.acls.HibernateMutableAclService;
import com.atlassian.bamboo.util.BambooStringUtils;
import com.atlassian.bamboo.utils.XsrfUtils;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySetManager;
import com.atlassian.event.api.EventPublisher;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Suppliers;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.acegisecurity.acls.AccessControlEntry;
import org.acegisecurity.acls.MutableAcl;
import org.acegisecurity.acls.Permission;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ConfigureSecurity
extends GlobalAdminAction {
    public static final BiMap<String, TimeUnit> SUPPORTED_MANUAL_ENCRYPTION_TIME_UNITS = new ImmutableBiMap.Builder().put((Object)"config.security.manual.encryption.limit.unit.hour", (Object)TimeUnit.HOURS).put((Object)"config.security.manual.encryption.limit.unit.day", (Object)TimeUnit.DAYS).build();
    @Inject
    private EventPublisher eventPublisher;
    @Inject
    private GlobalPermissionsService globalPermissionsService;
    private boolean enableSignup;
    private boolean enableCaptchaOnSignup;
    private boolean enableViewContactDetails;
    private boolean enableRestrictedAdmin;
    private boolean enableCaptcha;
    private boolean showAdminContactDetailsToAnonymousUsers;
    private boolean soxComplianceModeEnabled;
    private boolean isXsrfProtectionEnabled;
    private boolean areMutativeGetsAllowed;
    private boolean resolveArtifactContentTypeByExtension;
    private String xstreamSerializationProtectionMethod;
    private String bandanaSerializationProtectionMethod;
    private boolean manageAcceptedSshHostKeys;
    private boolean unauthenticatedRemoteTriggerAllowed;
    private boolean agentAssignmentModificationByUsersAllowed;
    private boolean rssEnabled;
    private boolean rssExecuteSpecsInDocker;
    private String rssDockerImage;
    private boolean rssMountLocalMavenDirectory;
    private String rssLocalMavenDirectory;
    private boolean manualEncryptionEnabled;
    private int manualEncryptionLimit;
    private String manualEncryptionLimitUnit;
    private String loginAttempts;
    @Inject
    private HibernateMutableAclService aclService;
    @Inject
    private CapabilitySetManager capabilitySetManager;
    private Supplier<Boolean> dockerConfigured = Suppliers.memoize(() -> BambooDockerHelper.isDockerExecutableConfigured((CapabilitySetManager)this.capabilitySetManager));
    private Supplier<List<NameValuePair>> manualEncryptionTimeUnits = Suppliers.memoize(() -> SUPPORTED_MANUAL_ENCRYPTION_TIME_UNITS.entrySet().stream().map(entry -> new NameValuePair(((TimeUnit)((Object)((Object)((Object)entry.getValue())))).name(), this.getText((String)entry.getKey()))).collect(Collectors.toList()));

    public void validate() {
        super.validate();
        this.getAdministrationConfiguration();
        if (this.isEnableCaptcha() && this.getLoginAttemptsAsInt() <= 0) {
            this.addFieldError("loginAttempts", this.getText("config.security.loginAttemptsInvalid"));
        }
        if (this.rssExecuteSpecsInDocker) {
            if (StringUtils.isBlank((CharSequence)this.rssDockerImage)) {
                this.addFieldError("rssDockerImage", this.getText("config.security.rssDockerImage.error.empty"));
            }
            if (this.rssMountLocalMavenDirectory) {
                if (StringUtils.isBlank((CharSequence)this.rssLocalMavenDirectory)) {
                    this.addFieldError("rssLocalMavenDirectory", this.getText("config.security.rss.rssLocalMavenDirectory.error.empty"));
                } else {
                    File mavenDirFile = new File(this.rssLocalMavenDirectory);
                    if (!mavenDirFile.isAbsolute()) {
                        this.addFieldError("rssLocalMavenDirectory", this.getText("config.security.rss.rssLocalMavenDirectory.error.notabsolute"));
                    } else if (!mavenDirFile.isDirectory()) {
                        this.addFieldError("rssLocalMavenDirectory", this.getText("config.security.rss.rssLocalMavenDirectory.error.notexists", Collections.singletonList(this.rssLocalMavenDirectory)));
                    }
                }
            }
        }
        if (this.manualEncryptionEnabled) {
            if (this.manualEncryptionLimit <= 0) {
                this.addFieldError("manualEncryptionLimit", this.getText("config.security.manual.encryption.limit.invocations.error"));
            }
            if (SUPPORTED_MANUAL_ENCRYPTION_TIME_UNITS.values().stream().noneMatch(timeUnit -> Objects.equals(timeUnit.name(), this.manualEncryptionLimitUnit))) {
                this.addFieldError("manualEncryptionLimit", this.getText("config.security.manual.encryption.limit.unit.error", Collections.singletonList(SUPPORTED_MANUAL_ENCRYPTION_TIME_UNITS.values().stream().map(Enum::name).collect(Collectors.joining(", ")))));
            }
        }
    }

    public String input() throws Exception {
        AdministrationConfiguration administrationConfiguration = this.getAdministrationConfiguration();
        this.setEnableSignup(administrationConfiguration.isEnableSignup());
        this.setEnableRestrictedAdmin(administrationConfiguration.isEnableRestrictedAdmin());
        if (this.featureManager.isSoxComplianceModeConfigurable()) {
            this.setSoxComplianceModeEnabled(administrationConfiguration.isSoxComplianceModeEnabled());
        }
        this.setEnableCaptchaOnSignup(administrationConfiguration.getCaptchaConfiguration().isEnableCaptchaOnSignup());
        this.setEnableViewContactDetails(administrationConfiguration.isEnableViewContactDetails());
        this.setEnableCaptcha(administrationConfiguration.getCaptchaConfiguration().isEnableCaptcha());
        this.setShowAdminContactDetailsToAnonymousUsers(administrationConfiguration.isShowAdminContactDetailsToAnonymousUsers());
        this.setLoginAttempts(Integer.toString(administrationConfiguration.getCaptchaConfiguration().getMaxLoginAttempts()));
        this.setXsrfProtectionEnabled(administrationConfiguration.isXsrfProtectionEnabled());
        this.setResolveArtifactContentTypeByExtension(administrationConfiguration.getResolveArtifactContentTypeByExtension());
        this.setXstreamSerializationProtectionMethod(administrationConfiguration.getSerializationSecurityConfig().getxStreamMethod().name());
        this.setBandanaSerializationProtectionMethod(administrationConfiguration.getSerializationSecurityConfig().getBandanaMethod().name());
        this.areMutativeGetsAllowed = administrationConfiguration.doesXsrfAllowMutativeGets();
        this.setManageAcceptedSshHostKeys(administrationConfiguration.isManageAcceptedSshHostKeys());
        this.setUnauthenticatedRemoteTriggerAllowed(administrationConfiguration.isUnauthenticatedRemoteTriggerAllowed());
        this.setAgentAssignmentModificationByUsersAllowed(administrationConfiguration.isAgentAssignmentModificationByUsersAllowed());
        if (this.featureManager.isRepositoryStoredSpecsEnabled()) {
            RssSecurityConfiguration rssSecurityConfiguration = administrationConfiguration.getRssSecurityConfiguration();
            this.setRssEnabled(rssSecurityConfiguration.isEnabled());
            this.setRssExecuteSpecsInDocker(rssSecurityConfiguration.isExecuteSpecsInDocker());
            this.setRssDockerImage((String)StringUtils.defaultIfBlank((CharSequence)rssSecurityConfiguration.getDockerImage(), (CharSequence)BambooDockerHelper.DEFAULT_RSS_DOCKER_IMAGE));
            this.setRssMountLocalMavenDirectory(rssSecurityConfiguration.isMountLocalMavenDirectory());
            this.setRssLocalMavenDirectory(rssSecurityConfiguration.getLocalMavenDirectory());
        }
        this.setManualEncryptionEnabled(administrationConfiguration.getManualEncryptionConfiguration().isEnabled());
        this.setManualEncryptionLimit(administrationConfiguration.getManualEncryptionConfiguration().getLimit());
        this.setManualEncryptionLimitUnit(administrationConfiguration.getManualEncryptionConfiguration().getLimitUnit().name());
        return "input";
    }

    public String execute() throws Exception {
        XsrfUtils.assertCanPerformMutativeAction((String)"Cannot perform mutative operation");
        AdministrationConfiguration administrationConfiguration = this.getAdministrationConfiguration();
        administrationConfiguration.setEnableSignup(this.enableSignup);
        administrationConfiguration.getCaptchaConfiguration().setEnableCaptchaOnSignup(this.enableCaptchaOnSignup);
        administrationConfiguration.setShowAdminContactDetailsToAnonymousUsers(this.showAdminContactDetailsToAnonymousUsers);
        administrationConfiguration.setEnableViewContactDetails(this.enableViewContactDetails);
        administrationConfiguration.setEnableRestrictedAdmin(this.enableRestrictedAdmin);
        if (this.featureManager.isSoxComplianceModeConfigurable()) {
            administrationConfiguration.setSoxComplianceModeEnabled(this.soxComplianceModeEnabled);
        }
        administrationConfiguration.getCaptchaConfiguration().setEnableCaptcha(this.enableCaptcha);
        administrationConfiguration.getCaptchaConfiguration().setMaxLoginAttempts(this.getLoginAttemptsAsInt());
        administrationConfiguration.setXsrfProtectionEnabled(this.isXsrfProtectionEnabled);
        administrationConfiguration.setXsrfAllowsMutativeGets(this.areMutativeGetsAllowed);
        administrationConfiguration.setResolveArtifactContentTypeByExtension(this.resolveArtifactContentTypeByExtension);
        administrationConfiguration.setSerializationSecurityConfig(new SerializationSecurityConfig(SerializationSecurityMethod.valueOf((String)this.bandanaSerializationProtectionMethod), SerializationSecurityMethod.valueOf((String)this.xstreamSerializationProtectionMethod)));
        administrationConfiguration.setManageAcceptedSshHostKeys(this.manageAcceptedSshHostKeys);
        administrationConfiguration.setUnauthenticatedRemoteTriggerAllowed(this.unauthenticatedRemoteTriggerAllowed);
        administrationConfiguration.setAgentAssignmentModificationByUsersAllowed(this.agentAssignmentModificationByUsersAllowed);
        if (this.featureManager.isRepositoryStoredSpecsEnabled()) {
            String currentRssDockerImage = administrationConfiguration.getRssSecurityConfiguration().getDockerImage();
            String newRssDockerImage = BambooStringUtils.firstNotBlank((String[])new String[]{this.rssDockerImage, currentRssDockerImage, BambooDockerHelper.DEFAULT_RSS_DOCKER_IMAGE});
            administrationConfiguration.setRssSecurityConfiguration(new RssSecurityConfiguration(this.rssEnabled, this.rssExecuteSpecsInDocker, newRssDockerImage, this.rssMountLocalMavenDirectory, this.rssLocalMavenDirectory));
        }
        this.administrationConfigurationPersister.saveAdministrationConfiguration(administrationConfiguration);
        this.enableRestrictedAdminRole(this.enableRestrictedAdmin);
        administrationConfiguration.setManualEncryptionConfiguration(new ManualEncryptionConfiguration(this.manualEncryptionEnabled, this.manualEncryptionLimit, TimeUnit.valueOf(this.manualEncryptionLimitUnit)));
        this.eventPublisher.publish((Object)new SecuritySettingsUpdatedEvent(administrationConfiguration, (Object)this));
        this.addActionMessage(this.getText("config.updated"));
        return "success";
    }

    private void enableRestrictedAdminRole(boolean enabled) {
        if (enabled) {
            AccessControlEntry[] entries;
            List permissionsRequiringRestrictedAdmin = this.globalPermissionsService.supportedPermissions().stream().filter(permission -> this.globalPermissionsService.permissionDependencies(permission).contains(BambooPermission.RESTRICTEDADMINISTRATION)).collect(Collectors.toList());
            MutableAcl acl = this.aclService.getAclOfGlobalPermission();
            for (AccessControlEntry entry : entries = acl.getEntries()) {
                if (!permissionsRequiringRestrictedAdmin.contains(entry.getPermission())) continue;
                acl.insertAce(entry.getId(), (Permission)BambooPermission.RESTRICTEDADMINISTRATION, entry.getSid(), true);
            }
            this.aclService.updateAcl(acl);
        } else {
            AccessControlEntry[] entries;
            MutableAcl acl = this.aclService.getAclOfGlobalPermission();
            for (AccessControlEntry entry : entries = acl.getEntries()) {
                if (!BambooPermission.RESTRICTEDADMINISTRATION.equals((Object)entry.getPermission())) continue;
                acl.deleteAce(entry.getId());
            }
            this.aclService.updateAcl(acl);
        }
    }

    public boolean isEnableCaptchaOnSignup() {
        return this.enableCaptchaOnSignup;
    }

    public void setEnableCaptchaOnSignup(boolean enableCaptchaOnSignup) {
        this.enableCaptchaOnSignup = enableCaptchaOnSignup;
    }

    public boolean isEnableCaptcha() {
        return this.enableCaptcha;
    }

    public void setEnableCaptcha(boolean enableCaptcha) {
        this.enableCaptcha = enableCaptcha;
    }

    public String getLoginAttempts() {
        return this.loginAttempts;
    }

    public void setLoginAttempts(String loginAttempts) {
        this.loginAttempts = loginAttempts;
    }

    public int getLoginAttemptsAsInt() {
        try {
            return Integer.parseInt(this.loginAttempts);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    public boolean isEnableSignup() {
        return this.enableSignup;
    }

    public void setEnableSignup(boolean enableSignup) {
        this.enableSignup = enableSignup;
    }

    public boolean isShowAdminContactDetailsToAnonymousUsers() {
        return this.showAdminContactDetailsToAnonymousUsers;
    }

    public void setShowAdminContactDetailsToAnonymousUsers(boolean showAdminContactDetailsToAnonymousUsers) {
        this.showAdminContactDetailsToAnonymousUsers = showAdminContactDetailsToAnonymousUsers;
    }

    public boolean isEnableViewContactDetails() {
        return this.enableViewContactDetails;
    }

    public void setEnableViewContactDetails(boolean enableViewContactDetails) {
        this.enableViewContactDetails = enableViewContactDetails;
    }

    public boolean isEnableRestrictedAdmin() {
        return this.enableRestrictedAdmin;
    }

    public void setEnableRestrictedAdmin(boolean enableRestrictedAdmin) {
        this.enableRestrictedAdmin = enableRestrictedAdmin;
    }

    public boolean isSoxComplianceModeEnabled() {
        return this.soxComplianceModeEnabled;
    }

    public void setSoxComplianceModeEnabled(boolean soxComplianceModeEnabled) {
        this.soxComplianceModeEnabled = soxComplianceModeEnabled;
    }

    public boolean isXsrfProtectionEnabled() {
        return this.isXsrfProtectionEnabled;
    }

    public void setXsrfProtectionEnabled(boolean xsrfProtectionEnabled) {
        this.isXsrfProtectionEnabled = xsrfProtectionEnabled;
    }

    public boolean isXsrfProtectionMutativeGetsAllowed() {
        return this.areMutativeGetsAllowed;
    }

    public void setXsrfProtectionMutativeGetsAllowed(boolean xsrfProtectionMutativeGetsAllowed) {
        this.areMutativeGetsAllowed = xsrfProtectionMutativeGetsAllowed;
    }

    public boolean isResolveArtifactContentTypeByExtension() {
        return this.resolveArtifactContentTypeByExtension;
    }

    public void setResolveArtifactContentTypeByExtension(boolean resolveArtifactContentTypeByExtension) {
        this.resolveArtifactContentTypeByExtension = resolveArtifactContentTypeByExtension;
    }

    public String getXstreamSerializationProtectionMethod() {
        return this.xstreamSerializationProtectionMethod;
    }

    public void setXstreamSerializationProtectionMethod(String xstreamSerializationProtectionMethod) {
        this.xstreamSerializationProtectionMethod = xstreamSerializationProtectionMethod;
    }

    public String getBandanaSerializationProtectionMethod() {
        return this.bandanaSerializationProtectionMethod;
    }

    public void setBandanaSerializationProtectionMethod(String bandanaSerializationProtectionMethod) {
        this.bandanaSerializationProtectionMethod = bandanaSerializationProtectionMethod;
    }

    @NotNull
    public Map<String, String> getSerializationProtectionOptionsForRemoting() {
        return ImmutableMap.builder().put((Object)SerializationSecurityMethod.WHITELIST.name(), (Object)this.getText("config.security.serialization.protection.method.whitelist")).put((Object)SerializationSecurityMethod.BLACKLIST.name(), (Object)this.getText("config.security.serialization.protection.method.xstream.blacklist")).put((Object)SerializationSecurityMethod.STRICT_BLACKLIST.name(), (Object)this.getText("config.security.serialization.protection.method.xstream.strictblacklist")).build();
    }

    @NotNull
    public Map<String, String> getSerializationProtectionOptionsForBandana() {
        return ImmutableMap.builder().put((Object)SerializationSecurityMethod.BLACKLIST.name(), (Object)this.getText("config.security.serialization.protection.method.blacklist")).put((Object)SerializationSecurityMethod.STRICT_BLACKLIST.name(), (Object)this.getText("config.security.serialization.protection.method.strictblacklist")).build();
    }

    public boolean isManageAcceptedSshHostKeys() {
        return this.manageAcceptedSshHostKeys;
    }

    public void setManageAcceptedSshHostKeys(boolean manageAcceptedSshHostKeys) {
        this.manageAcceptedSshHostKeys = manageAcceptedSshHostKeys;
    }

    public boolean isRssEnabled() {
        return this.rssEnabled;
    }

    public void setRssEnabled(boolean rssEnabled) {
        this.rssEnabled = rssEnabled;
    }

    public boolean isRssExecuteSpecsInDocker() {
        return this.rssExecuteSpecsInDocker;
    }

    public void setRssExecuteSpecsInDocker(boolean rssExecuteSpecsInDocker) {
        this.rssExecuteSpecsInDocker = rssExecuteSpecsInDocker;
    }

    public boolean isUnauthenticatedRemoteTriggerAllowed() {
        return this.unauthenticatedRemoteTriggerAllowed;
    }

    public void setUnauthenticatedRemoteTriggerAllowed(boolean unauthenticatedRemoteTriggerAllowed) {
        this.unauthenticatedRemoteTriggerAllowed = unauthenticatedRemoteTriggerAllowed;
    }

    public boolean isAgentAssignmentModificationByUsersAllowed() {
        return this.agentAssignmentModificationByUsersAllowed;
    }

    public void setAgentAssignmentModificationByUsersAllowed(boolean agentAssignmentModificationByUsersAllowed) {
        this.agentAssignmentModificationByUsersAllowed = agentAssignmentModificationByUsersAllowed;
    }

    public String getRssDockerImage() {
        return this.rssDockerImage;
    }

    public void setRssDockerImage(String rssDockerImage) {
        this.rssDockerImage = rssDockerImage;
    }

    public boolean isDockerConfigured() {
        return this.dockerConfigured.get();
    }

    public String getRssDockerImageDescription() {
        return this.getText("config.security.rss.docker.image.description", Collections.singletonList(BambooDockerHelper.DEFAULT_RSS_DOCKER_IMAGE));
    }

    public boolean isManualEncryptionEnabled() {
        return this.manualEncryptionEnabled;
    }

    public void setManualEncryptionEnabled(boolean manualEncryptionEnabled) {
        this.manualEncryptionEnabled = manualEncryptionEnabled;
    }

    public int getManualEncryptionLimit() {
        return this.manualEncryptionLimit;
    }

    public void setManualEncryptionLimit(int manualEncryptionLimit) {
        this.manualEncryptionLimit = manualEncryptionLimit;
    }

    public String getManualEncryptionLimitUnit() {
        return this.manualEncryptionLimitUnit;
    }

    public void setManualEncryptionLimitUnit(String manualEncryptionLimitUnit) {
        this.manualEncryptionLimitUnit = manualEncryptionLimitUnit;
    }

    public List<NameValuePair> getSupportedManualEncryptionTimeUnits() {
        return this.manualEncryptionTimeUnits.get();
    }

    public boolean isRssMountLocalMavenDirectory() {
        return this.rssMountLocalMavenDirectory;
    }

    public void setRssMountLocalMavenDirectory(boolean rssMountLocalMavenDirectory) {
        this.rssMountLocalMavenDirectory = rssMountLocalMavenDirectory;
    }

    public String getRssLocalMavenDirectory() {
        return this.rssLocalMavenDirectory;
    }

    public void setRssLocalMavenDirectory(String rssLocalMavenDirectory) {
        this.rssLocalMavenDirectory = rssLocalMavenDirectory;
    }
}

