/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration;

import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.security.GlobalPermissionsService;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.utils.BambooCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.acegisecurity.acls.Permission;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class ConfigureGlobalPermissions
extends GlobalAdminAction {
    private static final Map<BambooPermission, String> PERMISSION_LABELS = ImmutableMap.builder().put((Object)BambooPermission.READ, (Object)"config.global.permissions.read").put((Object)BambooPermission.SOX_COMPLIANCE, (Object)"config.global.permissions.sox.compliance").put((Object)BambooPermission.CREATE, (Object)"config.global.permissions.create").put((Object)BambooPermission.CREATE_REPOSITORY, (Object)"config.global.permissions.create.repository").put((Object)BambooPermission.RESTRICTEDADMINISTRATION, (Object)"config.global.permissions.restricted.admin").put((Object)BambooPermission.ADMINISTRATION, (Object)"config.global.permissions.admin").build();
    @Autowired
    private GlobalPermissionsService globalPermissionsService;

    @NotNull
    public Map<String, String> getSupportedPermissions() {
        return (Map)this.globalPermissionsService.supportedPermissions().stream().collect(BambooCollectors.toImmutableMap(PERMISSION_LABELS::get, BambooPermission::getName));
    }

    @NotNull
    public List<String> getEditablePermissions() {
        return this.globalPermissionsService.editablePermissions().stream().map(BambooPermission::getName).collect(Collectors.toList());
    }

    @NotNull
    public List<String> getPermissionDependencies(@NotNull String permissionName) {
        Permission permission = BambooPermission.buildFromName((String)permissionName);
        Preconditions.checkState((boolean)(permission instanceof BambooPermission));
        return this.globalPermissionsService.permissionDependencies((BambooPermission)permission).stream().map(BambooPermission::getName).collect(Collectors.toList());
    }
}

