/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration;

import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.configuration.InetAddressBean;
import com.atlassian.bamboo.configuration.RssDetectionConfiguration;
import com.atlassian.bamboo.configuration.external.polling.RepositoryStoredSpecsPollingScheduler;
import com.atlassian.bamboo.plan.BranchAndTagDetectionJobScheduler;
import com.atlassian.bamboo.plan.pullrequest.PullRequestDetectionJobScheduler;
import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.setup.BrokerURIUtils;
import com.atlassian.bamboo.user.gravatar.GravatarService;
import com.atlassian.bamboo.util.BambooCollectionUtils;
import com.atlassian.bamboo.util.RequestCacheThreadLocal;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalAdminSecurityAware;
import com.atlassian.bamboo.ww2.validators.XssSafeValidator;
import com.opensymphony.xwork2.validator.FieldValidator;
import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.validators.IntRangeFieldValidator;
import com.opensymphony.xwork2.validator.validators.RequiredStringValidator;
import com.opensymphony.xwork2.validator.validators.URLValidator;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.quartz.CronExpression;
import org.quartz.SchedulerException;

public class ConfigurationAction
extends GlobalAdminAction
implements GlobalAdminSecurityAware {
    private static final Logger log = Logger.getLogger(ConfigurationAction.class);
    private static final String FIELD_BASE_URL = "baseUrl";
    private static final String FIELD_GRAVATAR_URL = "gravatarServerUrl";
    private static final String FIELD_RSS_CRON = "rssPollingCron";
    private String instanceName;
    private String baseUrl;
    private int dashboardPageSize;
    private boolean gzipCompressionEnabled;
    private boolean enableGravatar;
    private String gravatarServerUrl;
    private String brokerUrl;
    private String brokerClientUrl;
    private int branchDetectionInterval;
    private boolean enableRssPolling;
    private String rssPollingCron;
    @Inject
    private GravatarService gravatarService;
    @Inject
    private BootstrapManager bootstrapManager;
    @Inject
    private BranchAndTagDetectionJobScheduler branchAndTagDetectionJobScheduler;
    @Inject
    private PullRequestDetectionJobScheduler pullRequestDetectionJobScheduler;
    @Inject
    private RepositoryStoredSpecsPollingScheduler repositoryStoredSpecsPollingScheduler;

    public void validate() {
        IntRangeFieldValidator branchDetectionIntervalValidator;
        ArrayList<IntRangeFieldValidator> validators = new ArrayList<IntRangeFieldValidator>();
        BambooCollectionUtils.addIgnoreNull(validators, (Object)this.createFieldValidator(FIELD_BASE_URL, RequiredStringValidator.class, "config.server.baseUrl.error.required", null));
        BambooCollectionUtils.addIgnoreNull(validators, (Object)this.createFieldValidator(FIELD_BASE_URL, URLValidator.class, "config.server.baseUrl.error.invalid", null));
        BambooCollectionUtils.addIgnoreNull(validators, (Object)((Object)this.createFieldValidator(FIELD_BASE_URL, XssSafeValidator.class, "config.server.baseUrl.error.invalid", null)));
        IntRangeFieldValidator dashboardPageSizeValidator = this.createFieldValidator("dashboardPageSize", IntRangeFieldValidator.class, "config.server.dashboardPageSize.error.invalid", null);
        if (dashboardPageSizeValidator != null) {
            dashboardPageSizeValidator.setMin((Comparable)Integer.valueOf(1));
            validators.add(dashboardPageSizeValidator);
        }
        if ((branchDetectionIntervalValidator = this.createFieldValidator("branchDetectionInterval", IntRangeFieldValidator.class, "config.server.branchDetectionInterval.error.invalid", null)) != null) {
            branchDetectionIntervalValidator.setMin((Comparable)Integer.valueOf(1));
            validators.add(branchDetectionIntervalValidator);
        }
        if (this.isEnableGravatar()) {
            BambooCollectionUtils.addIgnoreNull(validators, (Object)this.createFieldValidator(FIELD_GRAVATAR_URL, RequiredStringValidator.class, "config.server.gravatarUrlField.required", null));
            BambooCollectionUtils.addIgnoreNull(validators, (Object)this.createFieldValidator(FIELD_GRAVATAR_URL, URLValidator.class, "config.server.gravatarUrlField.error.invalid", null));
            BambooCollectionUtils.addIgnoreNull(validators, (Object)((Object)this.createFieldValidator(FIELD_GRAVATAR_URL, XssSafeValidator.class, "config.server.gravatarUrlField.error.invalid", null)));
        }
        if (this.isEnableRssPolling()) {
            if (StringUtils.isEmpty((CharSequence)this.getRssPollingCron())) {
                this.addError(FIELD_RSS_CRON, this.getText("repository.change.schedule.cronExpression.error.required"));
            } else {
                try {
                    CronExpression cronExpr = new CronExpression(this.getRssPollingCron());
                    cronExpr.getNextValidTimeAfter(new Date());
                }
                catch (ParseException e) {
                    this.addError(FIELD_RSS_CRON, this.getText("repository.change.schedule.cronExpression.error.invalid"));
                }
                catch (UnsupportedOperationException e) {
                    this.addError(FIELD_RSS_CRON, this.getText("repository.change.schedule.cronExpression.error.unsupported"));
                }
                catch (Exception e) {
                    this.addError(FIELD_RSS_CRON, this.getText("repository.change.schedule.cronExpression.error.failure"));
                }
            }
        }
        try {
            for (FieldValidator fieldValidator : validators) {
                fieldValidator.validate((Object)this);
            }
        }
        catch (ValidationException e) {
            log.warn((Object)"Exception during validation", (Throwable)e);
        }
    }

    public String execute() throws Exception {
        AdministrationConfiguration administrationConfiguration = this.getAdministrationConfiguration();
        if (administrationConfiguration != null) {
            if (StringUtils.isNotBlank((CharSequence)this.getBaseUrl())) {
                administrationConfiguration.setBaseUrl(this.getBaseUrl());
            }
            administrationConfiguration.setUseGzipCompression(this.getGzipCompression());
            if (StringUtils.isNotBlank((CharSequence)this.getInstanceName())) {
                administrationConfiguration.setInstanceName(this.getInstanceName());
            }
            administrationConfiguration.setDashboardPageSize(this.dashboardPageSize);
            administrationConfiguration.setBranchDetectionCheckInterval(this.branchDetectionInterval);
            administrationConfiguration.setRssDetectionConfiguration(new RssDetectionConfiguration(this.enableRssPolling, this.rssPollingCron));
            this.administrationConfigurationPersister.saveAdministrationConfiguration(administrationConfiguration);
            try {
                this.updateBrokerSettings();
            }
            catch (URISyntaxException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                this.addActionError(e.getMessage());
                return "error";
            }
            try {
                this.branchAndTagDetectionJobScheduler.rescheduleDetecting();
                this.pullRequestDetectionJobScheduler.reschedulePullRequestDetecting();
                this.repositoryStoredSpecsPollingScheduler.rescheduleRssPolling();
            }
            catch (SchedulerException e) {
                log.error((Object)("Could not reset branch detection scheduler: " + e.getMessage()), (Throwable)e);
            }
        } else {
            this.addActionError(this.getText("config.error.general"));
            return "error";
        }
        if (StringUtils.isEmpty((CharSequence)this.gravatarServerUrl)) {
            this.setGravatarServerUrl("https://secure.gravatar.com/avatar/");
        }
        this.gravatarService.setGravatarSupported(this.enableGravatar, this.gravatarServerUrl);
        if (!this.hasActionWarnings()) {
            this.addActionMessage(this.getText("config.updated"));
        }
        return "success";
    }

    public String input() throws Exception {
        AdministrationConfiguration administrationConfiguration = this.getAdministrationConfiguration();
        if (administrationConfiguration != null) {
            this.setInstanceName(administrationConfiguration.getInstanceName());
            this.setBaseUrl(administrationConfiguration.getBaseUrl());
            this.setGzipCompression(administrationConfiguration.isUseGzipCompression());
            this.setDashboardPageSize(administrationConfiguration.getDashboardPageSize());
            this.setBranchDetectionInterval(administrationConfiguration.getBranchDetectionCheckInterval());
            this.setEnableRssPolling(administrationConfiguration.getRssDetectionConfiguration().isPollingEnabled());
            this.setRssPollingCron(administrationConfiguration.getRssDetectionConfiguration().getPollingCronExpression());
        }
        this.setEnableGravatar(this.gravatarService.isGravatarSupportEnabled());
        this.setGravatarServerUrl(this.gravatarService.getGravatarServerUrl());
        this.brokerUrl = this.bootstrapManager.getBrokerURI().toString();
        this.brokerClientUrl = this.bootstrapManager.getBrokerClientURI().toString();
        return "input";
    }

    public String getDefaultBaseUrl() {
        HttpServletRequest request = RequestCacheThreadLocal.getNonNullRequest();
        String requestUrl = request.getRequestURL().toString();
        if (requestUrl.isEmpty()) {
            return "http://localhost:8085";
        }
        String servletPath = request.getServletPath();
        if (requestUrl.length() <= servletPath.length()) {
            return "http://localhost:8085";
        }
        String localhostUrl = requestUrl.substring(0, requestUrl.length() - servletPath.length());
        return InetAddressBean.getLocalHostAddressForUrl().map(address -> StringUtils.replace((String)localhostUrl, (String)"localhost", (String)address)).orElse(localhostUrl);
    }

    public String getActualBaseUrl() {
        AdministrationConfiguration administrationConfiguration = this.getAdministrationConfiguration();
        if (administrationConfiguration != null) {
            return administrationConfiguration.getBaseUrl();
        }
        return null;
    }

    private void updateBrokerSettings() throws URISyntaxException {
        String warningMessage = "";
        URI brokerUri = new URI(this.brokerUrl);
        if (this.isValidUri(brokerUri)) {
            String previousBrokerUrl = this.bootstrapManager.getBrokerURI().toString();
            this.bootstrapManager.setBrokerURI(brokerUri);
            if (!StringUtils.equals((CharSequence)this.brokerUrl, (CharSequence)previousBrokerUrl)) {
                warningMessage = this.getText("config.options.brokerUrl.updated") + " ";
            }
        } else {
            this.addFieldError("brokerUrl", this.getText("config.options.brokerUrl.error.invalid"));
        }
        URI clientBrokerUri = new URI(this.brokerClientUrl);
        if (this.isValidUri(clientBrokerUri)) {
            String previousBrokerClientUrl = this.bootstrapManager.getBrokerClientURI().toString();
            this.bootstrapManager.setBrokerClientURI(clientBrokerUri);
            if (!StringUtils.equals((CharSequence)this.brokerClientUrl, (CharSequence)previousBrokerClientUrl)) {
                warningMessage = warningMessage + this.getText("config.options.brokerClientUrl.updated");
            }
        } else {
            this.addFieldError("brokerClientUrl", this.getText("config.options.brokerClientUrl.error.invalid"));
        }
        if (StringUtils.isNotEmpty((CharSequence)warningMessage)) {
            this.addActionWarning(this.getText("config.updated") + ". " + warningMessage);
        }
    }

    private boolean isValidUri(URI uri) {
        try {
            BrokerURIUtils.decorateBrokerURI(uri);
            return true;
        }
        catch (Exception e) {
            log.info((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String url) {
        this.baseUrl = url;
    }

    public void setGzipCompression(boolean enabled) {
        this.gzipCompressionEnabled = enabled;
    }

    public boolean getGzipCompression() {
        return this.gzipCompressionEnabled;
    }

    @Override
    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public boolean isEnableGravatar() {
        return this.enableGravatar;
    }

    public void setEnableGravatar(boolean enableGravatar) {
        this.enableGravatar = enableGravatar;
    }

    public void setGravatarService(GravatarService gravatarService) {
        this.gravatarService = gravatarService;
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public void setBranchAndTagDetectionJobScheduler(BranchAndTagDetectionJobScheduler branchAndTagDetectionJobScheduler) {
        this.branchAndTagDetectionJobScheduler = branchAndTagDetectionJobScheduler;
    }

    public void setPullRequestDetectionJobScheduler(PullRequestDetectionJobScheduler pullRequestDetectionJobScheduler) {
        this.pullRequestDetectionJobScheduler = pullRequestDetectionJobScheduler;
    }

    public int getDashboardPageSize() {
        return this.dashboardPageSize;
    }

    public void setDashboardPageSize(int dashboardPageSize) {
        this.dashboardPageSize = dashboardPageSize;
    }

    public String getGravatarServerUrl() {
        return this.gravatarServerUrl;
    }

    public void setGravatarServerUrl(String gravatarServerUrl) {
        this.gravatarServerUrl = gravatarServerUrl;
    }

    public String getBrokerUrl() {
        return this.brokerUrl;
    }

    public void setBrokerUrl(String url) {
        this.brokerUrl = url;
    }

    public String getBrokerClientUrl() {
        return this.brokerClientUrl;
    }

    public void setBrokerClientUrl(String url) {
        this.brokerClientUrl = url;
    }

    public int getBranchDetectionInterval() {
        return this.branchDetectionInterval;
    }

    public void setBranchDetectionInterval(int branchDetectionInterval) {
        this.branchDetectionInterval = branchDetectionInterval;
    }

    public boolean isEnableRssPolling() {
        return this.enableRssPolling;
    }

    public void setEnableRssPolling(boolean enableRssPolling) {
        this.enableRssPolling = enableRssPolling;
    }

    public String getRssPollingCron() {
        return this.rssPollingCron;
    }

    public void setRssPollingCron(String rssPollingCron) {
        this.rssPollingCron = rssPollingCron;
    }
}

