/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration;

import com.atlassian.bamboo.security.GlobalApplicationSecureObject;
import com.atlassian.bamboo.security.acegi.BambooAcegiSecurityUtils;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.security.acegi.acls.GroupPrincipalSid;
import com.atlassian.bamboo.security.acegi.acls.HibernateMutableAclService;
import com.atlassian.bamboo.security.acegi.acls.HibernateObjectIdentityImpl;
import com.atlassian.bamboo.user.Authority;
import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import java.io.Serializable;
import java.util.Optional;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.acls.Acl;
import org.acegisecurity.acls.MutableAcl;
import org.acegisecurity.acls.NotFoundException;
import org.acegisecurity.acls.Permission;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.acegisecurity.acls.sid.Sid;
import org.acegisecurity.userdetails.UserDetails;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class AddPermissionAction
extends BambooActionSupport {
    private static final String USER_PRINCIPAL_TYPE = "User";
    private static final String GROUP_PRINCIPAL_TYPE = "Group";
    @Autowired
    private HibernateMutableAclService aclService;
    @Autowired
    private BambooUserManager bambooUserManager;
    private MutableAcl acl;
    private Acl globalAcl;
    private String newUser;
    private String newGroup;
    private String principalType = "User";
    private String permissionToGrant;
    private String javaType;
    private long entityId;

    public String createPrincipal() throws Exception {
        switch (this.principalType) {
            case "User": {
                return this.addUserPrincipal();
            }
            case "Group": {
                return this.addGroupPrincipal();
            }
        }
        this.addActionError("Unknown principal type: " + this.principalType);
        return "error";
    }

    private String addUserPrincipal() throws Exception {
        BambooUser user = this.bambooUserManager.getBambooUser(this.newUser);
        if (user == null) {
            this.addActionError("The user you specified is not valid.");
            return "error";
        }
        MutableAcl acl = this.getAcl();
        if (acl == null) {
            this.addActionError("Could not perform operation, no permission settings available for this entity.");
            return "error";
        }
        PrincipalSid userSid = new PrincipalSid(this.newUser);
        Permission permission = Optional.ofNullable(this.getPermissionToGrant()).map(BambooPermission::buildFromName).orElse((Permission)BambooPermission.READ);
        acl.insertAce(null, permission, (Sid)userSid, true);
        if (this.getAdministrationConfiguration().isSoxComplianceModeEnabled() && BambooAcegiSecurityUtils.hasAuthority((UserDetails)user, (GrantedAuthority)Authority.SOX_COMPLIANT_USER)) {
            acl.insertAce(null, (Permission)BambooPermission.BUILD, (Sid)userSid, true);
        }
        this.aclService.updateAcl(acl);
        return "success";
    }

    private String addGroupPrincipal() throws Exception {
        if (this.bambooUserManager.getGroup(this.newGroup) == null) {
            this.addActionError("The group you specified is not valid");
            return "error";
        }
        MutableAcl acl = this.getAcl();
        if (acl == null) {
            this.addActionError("Could not perform operation, no permission settings available for this entity.");
            return "error";
        }
        GroupPrincipalSid groupSid = new GroupPrincipalSid(this.newGroup);
        Permission permission = Optional.ofNullable(this.getPermissionToGrant()).map(BambooPermission::buildFromName).orElse((Permission)BambooPermission.READ);
        acl.insertAce(null, permission, (Sid)groupSid, true);
        if (this.getAdministrationConfiguration().isSoxComplianceModeEnabled() && this.hasSoxCompliancePermission((Sid)groupSid)) {
            acl.insertAce(null, (Permission)BambooPermission.BUILD, (Sid)groupSid, true);
        }
        this.aclService.updateAcl(acl);
        return "success";
    }

    private boolean hasSoxCompliancePermission(@NotNull Sid sid) {
        try {
            return this.getGlobalAcl().isGranted(new Permission[]{BambooPermission.SOX_COMPLIANCE}, new Sid[]{sid}, false);
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    @NotNull
    private ObjectIdentity getObjectIdentity() {
        return new HibernateObjectIdentityImpl(this.javaType, (Serializable)Long.valueOf(this.entityId));
    }

    @Nullable
    public MutableAcl getAcl() {
        if (this.acl == null) {
            this.acl = this.aclService.readMutableAclById(this.getObjectIdentity());
        }
        return this.acl;
    }

    public void setAcl(MutableAcl acl) {
        this.acl = acl;
    }

    private Acl getGlobalAcl() {
        if (this.globalAcl == null) {
            this.globalAcl = this.aclService.readMutableAclById((ObjectIdentity)new HibernateObjectIdentityImpl((Object)GlobalApplicationSecureObject.INSTANCE));
        }
        return this.globalAcl;
    }

    public String getNewUser() {
        return this.newUser;
    }

    public void setNewUser(String newUser) {
        this.newUser = newUser;
    }

    public String getNewGroup() {
        return this.newGroup;
    }

    public void setNewGroup(String newGroup) {
        this.newGroup = newGroup;
    }

    public long getEntityId() {
        return this.entityId;
    }

    public void setEntityId(long entityId) {
        this.entityId = entityId;
    }

    public String getJavaType() {
        return this.javaType;
    }

    public void setJavaType(String javaType) {
        this.javaType = javaType;
    }

    public String getPrincipalType() {
        return this.principalType;
    }

    public void setPrincipalType(String principalType) {
        this.principalType = principalType;
    }

    public String getPermissionToGrant() {
        return this.permissionToGrant;
    }

    public void setPermissionToGrant(String permissionToGrant) {
        this.permissionToGrant = permissionToGrant;
    }
}

