/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration;

import com.atlassian.bamboo.security.acegi.acls.BambooAclUpdateHelper;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.security.acegi.acls.GroupPrincipalSid;
import com.atlassian.bamboo.security.acegi.acls.HibernateMutableAclService;
import com.atlassian.bamboo.security.acegi.acls.objectidentity.ObjectIdentityUtils;
import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.opensymphony.xwork2.ActionContext;
import io.atlassian.util.concurrent.LazyReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.acegisecurity.acls.Acl;
import org.acegisecurity.acls.MutableAcl;
import org.acegisecurity.acls.Permission;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.acegisecurity.acls.sid.Sid;
import org.apache.commons.collections4.MapUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPermissionAction
extends BambooActionSupport {
    private static final Logger log = Logger.getLogger(AbstractPermissionAction.class);
    protected HibernateMutableAclService aclService;
    protected BambooAclUpdateHelper aclUpdateHelper;
    protected UserManager userManager;
    protected MutableAcl acl;
    protected List<String> grantedPermissions;
    protected List<String> nonProcessedGrantedPermissions;
    protected List<String> grantedUsers;
    protected List<String> grantedGroups;
    protected String newUser;
    protected String newGroup;
    protected String addUserPrincipal;
    protected String addGroupPrincipal;
    protected String principalType = "User";
    protected long entityId;
    private final LazyReference<Map<String, String>> grantedUsersDisplayNames = new LazyReference<Map<String, String>>(){

        protected Map<String, String> create() throws Exception {
            List<String> grantedUsers = AbstractPermissionAction.this.getGrantedUsers();
            HashMap<String, String> grantedUsersDisplayNames = new HashMap<String, String>();
            for (String loginName : grantedUsers) {
                try {
                    User user = AbstractPermissionAction.this.userManager.getUser(loginName);
                    String userName = null;
                    if (user != null) {
                        userName = user.getFullName();
                    } else {
                        log.info((Object)("User [" + loginName + "] not found"));
                    }
                    if (userName == null) {
                        userName = loginName;
                    }
                    grantedUsersDisplayNames.put(loginName, userName);
                }
                catch (EntityException entityException) {}
            }
            return grantedUsersDisplayNames;
        }
    };

    @Nullable
    public abstract MutableAcl getAcl();

    @NotNull
    public abstract String getEntityName();

    @NotNull
    public abstract Class<?> getEntityType();

    @NotNull
    public Class<?> getEntityAclType() {
        return (Class)ObjectIdentityUtils.getAclClassForEntityClass(this.getEntityType()).orElseThrow(() -> new IllegalStateException(String.format("Can't determine ACL class for %s", this.getEntityName())));
    }

    @NotNull
    public abstract Map<String, String> getEditablePermissions();

    public BambooPermission getMinimalPermission() {
        return BambooPermission.READ;
    }

    public boolean showAdminPermissions() {
        return this.hasGlobalAdminPermission();
    }

    protected void populatePermissionLists() {
        this.grantedPermissions = new ArrayList<String>();
        this.grantedUsers = new ArrayList<String>();
        this.grantedGroups = new ArrayList<String>();
        this.nonProcessedGrantedPermissions = new ArrayList<String>();
        MutableAcl acl = this.getAcl();
        if (acl != null) {
            this.aclUpdateHelper.buildPermissionAndUserGroupListsFromAcl(this.grantedPermissions, this.grantedUsers, this.grantedGroups, this.nonProcessedGrantedPermissions, (Acl)acl, this.showAdminPermissions(), this.getBambooPermissionManager());
        }
    }

    protected boolean hasParameters() {
        return MapUtils.isNotEmpty((Map)ActionContext.getContext().getParameters());
    }

    protected void updateAcl(MutableAcl acl) {
        this.aclService.updateAcl(acl);
    }

    protected void bulkUpdateAcls(MutableAcl acl, List<String> permissions) {
        this.aclService.updateAclAces(acl, permissions);
    }

    protected String saveAllPermissions() {
        MutableAcl acl = this.getAcl();
        if (acl == null) {
            this.addActionError("Could not perform operation, no permission settings available for this " + this.getEntityName() + ".");
            return "error";
        }
        if (this.grantedPermissions == null) {
            this.grantedPermissions = new ArrayList<String>();
        }
        if (this.hasActionErrors()) {
            ArrayList<String> grantedUsers = new ArrayList<String>();
            ArrayList<String> grantedGroups = new ArrayList<String>();
            this.aclUpdateHelper.buildUserGroupListsFromPermissions(this.grantedPermissions, grantedUsers, grantedGroups);
            this.setGrantedUsers(grantedUsers);
            this.setGrantedGroups(grantedGroups);
            return "input";
        }
        this.bulkUpdateAcls(acl, this.grantedPermissions);
        return "success";
    }

    public String doInputPrincipal() throws Exception {
        return "input";
    }

    public String doCreatePrincipal() throws Exception {
        if (this.principalType.equals("User")) {
            return this.doAddUserPrincipal();
        }
        return this.doAddGroupPrincipal();
    }

    public String doAddUserPrincipal() throws Exception {
        BambooUser user = this.getBambooUserManager().getBambooUser(this.getNewUser());
        if (user == null) {
            this.addActionError("The user you specified is not valid.");
            return "input";
        }
        this.setNewUser(user.getUsername());
        MutableAcl acl = this.getAcl();
        if (acl == null) {
            this.addActionError("Could not perform operation, no permission settings available for this deployment project.");
            return "input";
        }
        acl.insertAce(null, (Permission)this.getMinimalPermission(), (Sid)new PrincipalSid(this.getNewUser()), true);
        this.updateAcl(acl);
        return "success";
    }

    public String doAddGroupPrincipal() throws Exception {
        if (this.getBambooUserManager().getGroup(this.getNewGroup()) == null) {
            this.addActionError("The group you specified is not valid");
            return "input";
        }
        MutableAcl acl = this.getAcl();
        if (acl == null) {
            this.addActionError("Could not perform operation, no permission settings available for this deployment project.");
            return "error";
        }
        acl.insertAce(null, (Permission)this.getMinimalPermission(), (Sid)new GroupPrincipalSid(this.getNewGroup()), true);
        this.updateAcl(acl);
        return "success";
    }

    protected String save() throws Exception {
        String result = "Add".equals(this.getAddUserPrincipal()) || "Add".equals(this.getAddGroupPrincipal()) ? ("Group".equals(this.getPrincipalType()) ? this.doAddGroupPrincipal() : this.doAddUserPrincipal()) : this.saveAllPermissions();
        if (this.getActionErrors().isEmpty() && this.getFieldErrors().isEmpty()) {
            return result;
        }
        return "input";
    }

    public String updatePermissions() throws Exception {
        if (!this.hasParameters()) {
            return "input";
        }
        return this.save();
    }

    public void setAclService(HibernateMutableAclService aclService) {
        this.aclService = aclService;
    }

    public void setAclUpdateHelper(BambooAclUpdateHelper aclUpdateHelper) {
        this.aclUpdateHelper = aclUpdateHelper;
    }

    public void setAcl(MutableAcl acl) {
        this.acl = acl;
    }

    public List<String> getGrantedPermissions() {
        if (this.grantedPermissions == null) {
            this.populatePermissionLists();
        }
        return this.grantedPermissions;
    }

    public void setGrantedPermissions(List<String> grantedPermissions) {
        this.grantedPermissions = grantedPermissions;
    }

    public List<String> getGrantedUsers() {
        if (this.grantedUsers == null) {
            this.populatePermissionLists();
        }
        return this.grantedUsers;
    }

    public void setGrantedUsers(List<String> grantedUsers) {
        this.grantedUsers = grantedUsers;
    }

    @NotNull
    public Map<String, String> getGrantedUsersDisplayNames() {
        return (Map)this.grantedUsersDisplayNames.get();
    }

    public List<String> getGrantedGroups() {
        if (this.grantedGroups == null) {
            this.populatePermissionLists();
        }
        return this.grantedGroups;
    }

    public void setGrantedGroups(List<String> grantedGroups) {
        this.grantedGroups = grantedGroups;
    }

    public String getNewUser() {
        return this.newUser;
    }

    public void setNewUser(String newUser) {
        this.newUser = newUser;
    }

    public String getNewGroup() {
        return this.newGroup;
    }

    public void setNewGroup(String newGroup) {
        this.newGroup = newGroup;
    }

    public long getEntityId() {
        return this.entityId;
    }

    public void setEntityId(long entityId) {
        this.entityId = entityId;
    }

    public String getAddUserPrincipal() {
        return this.addUserPrincipal;
    }

    public void setAddUserPrincipal(String addUserPrincipal) {
        this.addUserPrincipal = addUserPrincipal;
    }

    public String getAddGroupPrincipal() {
        return this.addGroupPrincipal;
    }

    public void setAddGroupPrincipal(String addGroupPrincipal) {
        this.addGroupPrincipal = addGroupPrincipal;
    }

    public String getPrincipalType() {
        return this.principalType;
    }

    public void setPrincipalType(String principalType) {
        this.principalType = principalType;
    }

    public boolean hasEditPermissionForUserName(String userName) {
        return true;
    }

    public boolean hasEditPermissionForUser(BambooUser user) {
        return true;
    }

    public boolean hasEditPermissionForGroup(String groupName) {
        return !this.getBambooPermissionManager().getAdminGroups().contains(groupName) || this.hasGlobalAdminPermission();
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }
}

