/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.chains;

import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.chains.ChainStageResult;
import com.atlassian.bamboo.chains.StageStatusHelper;
import com.opensymphony.xwork2.TextProvider;
import java.util.Arrays;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class StageStatusHelperImpl
implements StageStatusHelper {
    private static final Logger log = Logger.getLogger(StageStatusHelperImpl.class);
    private final TextProvider textProvider;

    public StageStatusHelperImpl(TextProvider textProvider) {
        this.textProvider = textProvider;
    }

    @Override
    @NotNull
    public String getDisplayClassForStage(@NotNull ChainStageResult chainStageResult) {
        return chainStageResult.getLifeCycleState().equals((Object)LifeCycleState.FINISHED) ? chainStageResult.getState().toString() : chainStageResult.getLifeCycleState().toString();
    }

    @Override
    @NotNull
    public String getDisplayMessageForStage(@NotNull ChainStageResult chainStageResult) {
        String stageStatus = chainStageResult.getBuildResults().size() > 0 ? (chainStageResult.isCompleted() ? (chainStageResult.isFailed() ? this.textProvider.getText("stage.status.failed.description", Arrays.asList(chainStageResult.getFailedBuildResults().size(), chainStageResult.getBuildResults().size())) : (chainStageResult.isSuccessful() ? this.textProvider.getText("stage.status.success.description", Arrays.asList(chainStageResult.getBuildResults().size())) : this.textProvider.getText("stage.status.notBuilt.description", Arrays.asList(chainStageResult.getBuildResults().size() - chainStageResult.getSuccessfulBuildResults().size(), chainStageResult.getBuildResults().size())))) : (chainStageResult.isPending() ? this.textProvider.getText("stage.status.pending.description", Arrays.asList(chainStageResult.getBuildResults().size())) : this.textProvider.getText("stage.status.inProgress.description", Arrays.asList(chainStageResult.getBuildResults().size())))) : this.textProvider.getText("stage.status.noJobs.description");
        return stageStatus;
    }

    @Override
    public boolean isCollapsedByDefault(@NotNull ChainStageResult chainStageResult, @NotNull Collection<ChainStageResult> chainStageResults) {
        return chainStageResults.size() != 1 && !chainStageResult.getState().equals((Object)BuildState.FAILED) && !chainStageResult.getLifeCycleState().equals((Object)LifeCycleState.IN_PROGRESS) && (!chainStageResult.getLifeCycleState().equals((Object)LifeCycleState.NOT_BUILT) || chainStageResult.getSuccessfulBuildResults().isEmpty());
    }
}

