/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.captcha;

import com.atlassian.security.random.DefaultSecureRandomService;
import com.atlassian.security.random.SecureRandomService;
import com.google.common.collect.Lists;
import com.octo.captcha.component.image.fontgenerator.FontGenerator;
import com.octo.captcha.component.image.fontgenerator.RandomFontGenerator;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class AtlassianRandomFontGenerator
implements FontGenerator {
    private static final int MIN_FONT_SIZE = 30;
    private static final int MAX_FONT_SIZE = 35;
    private final int[] STYLES = new int[]{0, 2, 1, 3};
    private static final String REQUIRED_CHARACTERS = "abcdefghijklmnopqrstuvwxyz0123456789";
    private final String[] badFontNamePrefixes = RandomFontGenerator.defaultBadFontNamePrefixes;
    private static final int GENERATED_FONTS_ARRAY_SIZE = 3000;
    private final Font[] generatedFonts = new Font[3000];
    private final SecureRandomService random = DefaultSecureRandomService.getInstance();
    private static final int MAX_NEEDED_FONTS = 20;

    public AtlassianRandomFontGenerator() {
        Object[] allFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        this.initializeFonts(Lists.newArrayList((Object[])allFonts));
    }

    public Font getFont() {
        return this.generatedFonts[this.random.nextInt(this.generatedFonts.length)];
    }

    public int getMinFontSize() {
        return 30;
    }

    public int getMaxFontSize() {
        return 35;
    }

    private void initializeFonts(ArrayList<Font> allSystemFonts) {
        if (allSystemFonts.isEmpty()) {
            throw new IllegalArgumentException("No system fonts found");
        }
        List<Font> randomFonts = this.getRandomFontsForCaptchas(allSystemFonts, 20);
        if (randomFonts.isEmpty()) {
            throw new IllegalArgumentException("Unable to find fonts for captcha, checked " + allSystemFonts.size() + " fonts");
        }
        this.generateRandomlyStyledFonts(randomFonts);
    }

    private void generateRandomlyStyledFonts(List<Font> fontList) {
        for (int i = 0; i < 3000; ++i) {
            Font font = fontList.get(i % fontList.size());
            this.generatedFonts[i] = this.applyRandomStyle(font);
        }
    }

    protected Font applyRandomStyle(Font font) {
        int fontSizeIncrement = 0;
        int fontSizeVariation = this.getMaxFontSize() - this.getMinFontSize();
        if (fontSizeVariation > 0) {
            fontSizeIncrement = this.random.nextInt(fontSizeVariation + 1);
        }
        return font.deriveFont(this.STYLES[this.random.nextInt(this.STYLES.length)], this.getMinFontSize() + fontSizeIncrement);
    }

    @NotNull
    protected List<Font> getRandomFontsForCaptchas(Iterable<Font> uncheckedFonts, int fontsToReturn) {
        ArrayList randomizedFonts = Lists.newArrayList(uncheckedFonts);
        Collections.shuffle(randomizedFonts);
        ArrayList<Font> goodFonts = new ArrayList<Font>();
        for (Font font : randomizedFonts) {
            if (!this.isBlacklisted(font) && AtlassianRandomFontGenerator.canDisplay(font, REQUIRED_CHARACTERS)) {
                goodFonts.add(font);
            }
            if (goodFonts.size() < fontsToReturn) continue;
            break;
        }
        return goodFonts;
    }

    private boolean isBlacklisted(Font f) {
        for (String prefix : this.badFontNamePrefixes) {
            if (StringUtils.isEmpty((CharSequence)prefix) || !f.getName().startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private static boolean canDisplay(Font f, String charsToDisplay) {
        for (int i = 0; i < charsToDisplay.length(); ++i) {
            if (f.canDisplay(charsToDisplay.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

