/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.builder.resultsfilter;

import com.atlassian.bamboo.builder.resultsfilter.BuildResultsFilter;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.AgentResultsSummaryManager;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryCriteria;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

public class TimeAgoBuildResultsFilter
implements BuildResultsFilter {
    private static final Logger log = Logger.getLogger(TimeAgoBuildResultsFilter.class);
    private int days;
    private final AgentResultsSummaryManager agentResultsSummaryManager;
    private final PlanManager planManager;
    private final ResultsSummaryManager resultsSummaryManager;

    public TimeAgoBuildResultsFilter(AgentResultsSummaryManager agentResultsSummaryManager, PlanManager planManager, ResultsSummaryManager resultsSummaryManager, int days) {
        this.agentResultsSummaryManager = agentResultsSummaryManager;
        this.planManager = planManager;
        this.resultsSummaryManager = resultsSummaryManager;
        this.days = days;
    }

    public String getLabel() {
        return "Last " + this.days + " days";
    }

    public String getCookieKey() {
        return "LAST_" + this.days + "_DAYS";
    }

    @Deprecated
    @NotNull
    public List<BuildResultsSummary> getBuildResultsForBuild(@Nullable ImmutableBuildable buildable) {
        if (buildable == null) {
            log.warn((Object)("Null build passed for filter. " + (ServletActionContext.getRequest() != null ? "From:" + ServletActionContext.getRequest().getRequestURI() : "")));
            return Collections.emptyList();
        }
        if (!this.planManager.assertPlanPermission((PlanIdentifier)buildable)) {
            return Collections.emptyList();
        }
        ResultsSummaryCriteria criteria = new ResultsSummaryCriteria(buildable.getKey());
        criteria.setFromDate(this.getStartSearchPeriodDate());
        return this.resultsSummaryManager.getResultSummaries(criteria);
    }

    @NotNull
    public List<ResultsSummary> getResultsForPlan(@Nullable ImmutablePlan plan) {
        if (plan == null) {
            log.warn((Object)("Null build passed for filter. " + (ServletActionContext.getRequest() != null ? "From:" + ServletActionContext.getRequest().getRequestURI() : "")));
            return Collections.emptyList();
        }
        if (!this.planManager.assertPlanPermission((PlanIdentifier)plan)) {
            return Collections.emptyList();
        }
        ResultsSummaryCriteria criteria = new ResultsSummaryCriteria(plan.getKey());
        criteria.setFromDate(this.getStartSearchPeriodDate());
        return this.resultsSummaryManager.getResultSummaries(criteria);
    }

    @NotNull
    public List<BuildResultsSummary> getBuildResultsForAgent(Long agentId) {
        Date fromDay = this.getStartSearchPeriodDate();
        return this.agentResultsSummaryManager.getLatestSummariesForAgent(agentId, fromDay);
    }

    private Date getStartSearchPeriodDate() {
        return new DateTime().minusDays(this.days).toDate();
    }

    public Date getFromDate() {
        return this.getStartSearchPeriodDate();
    }

    public int getFromBuildNumber(@NotNull PlanKey planKey) {
        return 0;
    }
}

