/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.builder.resultsfilter;

import com.atlassian.bamboo.builder.resultsfilter.BuildResultsFilter;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.AgentResultsSummaryManager;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryCriteria;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryCriteria;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.jetbrains.annotations.NotNull;

public class Latest25FiveBuildResultsFilter
implements BuildResultsFilter {
    private static final Logger log = Logger.getLogger(Latest25FiveBuildResultsFilter.class);
    private static final int MAX_ROW_COUNT = 25;
    private final AgentResultsSummaryManager agentResultsSummaryManager;
    private final PlanManager planManager;
    private final ResultsSummaryManager resultsSummaryManager;

    public Latest25FiveBuildResultsFilter(AgentResultsSummaryManager agentResultsSummaryManager, PlanManager planManager, ResultsSummaryManager resultsSummaryManager) {
        this.agentResultsSummaryManager = agentResultsSummaryManager;
        this.planManager = planManager;
        this.resultsSummaryManager = resultsSummaryManager;
    }

    public String getLabel() {
        return "Last 25 builds";
    }

    public String getCookieKey() {
        return "LAST_25_BUILDS";
    }

    @Deprecated
    @NotNull
    public List<BuildResultsSummary> getBuildResultsForBuild(ImmutableBuildable buildable) {
        if (buildable == null) {
            log.warn((Object)("Null build passed for filter. " + (ServletActionContext.getRequest() != null ? "From:" + ServletActionContext.getRequest().getRequestURI() : "")));
            return Collections.emptyList();
        }
        if (!this.planManager.assertPlanPermission((PlanIdentifier)buildable)) {
            return Collections.emptyList();
        }
        return this.resultsSummaryManager.getResultSummaries((ResultsSummaryCriteria)new BuildResultsSummaryCriteria(buildable.getKey(), 25));
    }

    @NotNull
    public List<ResultsSummary> getResultsForPlan(ImmutablePlan plan) {
        if (plan == null) {
            log.warn((Object)("Null build passed for filter. " + (ServletActionContext.getRequest() != null ? "From:" + ServletActionContext.getRequest().getRequestURI() : "")));
            return Collections.emptyList();
        }
        if (!this.planManager.assertPlanPermission((PlanIdentifier)plan)) {
            return Collections.emptyList();
        }
        return this.resultsSummaryManager.getLastNResultsSummaries(plan, 25);
    }

    @NotNull
    public List<BuildResultsSummary> getBuildResultsForAgent(Long agentId) {
        return this.agentResultsSummaryManager.getLatestSummariesForAgent(agentId, 25);
    }

    public Date getFromDate() {
        return null;
    }

    public int getFromBuildNumber(@NotNull PlanKey planKey) {
        ResultsSummaryCriteria criteria = new ResultsSummaryCriteria(planKey.getKey());
        criteria.setMaxRowCount(25);
        List resultSummaries = this.resultsSummaryManager.getResultSummaries(criteria);
        if (!resultSummaries.isEmpty()) {
            return ((ResultsSummary)resultSummaries.get(resultSummaries.size() - 1)).getBuildNumber();
        }
        return 0;
    }
}

