/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.builder.resultsfilter;

import com.atlassian.bamboo.builder.resultsfilter.BuildResultsFilter;
import com.atlassian.bamboo.builder.resultsfilter.BuildResultsFilterFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public final class BuildResultsFilterFactoryImpl
implements BuildResultsFilterFactory {
    private static final Logger log = Logger.getLogger(BuildResultsFilterFactoryImpl.class);
    private final Map<String, BuildResultsFilter> buildResultsFilters = new HashMap<String, BuildResultsFilter>();
    private final BuildResultsFilter defaultBuildResultsFilter;

    public BuildResultsFilterFactoryImpl(@NotNull Collection<BuildResultsFilter> filters, @NotNull BuildResultsFilter defaultBuildResultsFilter) {
        for (BuildResultsFilter buildResultsFilter : filters) {
            this.buildResultsFilters.put(buildResultsFilter.getCookieKey(), buildResultsFilter);
        }
        this.defaultBuildResultsFilter = defaultBuildResultsFilter;
    }

    @Override
    public BuildResultsFilter getInstanceWithCookieKey(String key) {
        BuildResultsFilter buildResultsFilter = this.buildResultsFilters.get(key);
        if (buildResultsFilter == null) {
            log.warn((Object)("Cannot create Build Results filter for " + key + " returning last 25 builds instead."));
            buildResultsFilter = this.defaultBuildResultsFilter;
        }
        return buildResultsFilter;
    }

    @Override
    public Collection<BuildResultsFilter> getBuildResultFilters() {
        return this.buildResultsFilters.values();
    }
}

