/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.tests;

import com.atlassian.bamboo.build.FilterController;
import com.atlassian.bamboo.build.tests.FailingTestCaseForDisplay;
import com.atlassian.bamboo.builder.resultsfilter.BuildResultsFilter;
import com.atlassian.bamboo.builder.resultsfilter.BuildResultsFilterFactory;
import com.atlassian.bamboo.plan.branch.ChainBranchUtils;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.tests.TestCase;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResult;
import com.atlassian.bamboo.resultsummary.tests.TestsManager;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.ww2.actions.PlanActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.PlanReadSecurityAware;
import com.atlassian.xwork.ParameterSafe;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class ViewTestsSummaryForPlan
extends PlanActionSupport
implements PlanReadSecurityAware {
    private static final Logger log = Logger.getLogger(ViewTestsSummaryForPlan.class);
    private List<FailingTestCaseForDisplay> mostFailingTests = new ArrayList<FailingTestCaseForDisplay>();
    private final List<TestCase> longestRunningTests = new ArrayList<TestCase>();
    private final List<Pair<TestCase, Float>> longestTimeToFixTests = new ArrayList<Pair<TestCase, Float>>();
    private BuildResultsFilter filter;
    private TestsManager testsManager;
    private BuildResultsFilterFactory buildResultsFilterFactory;
    private FilterController filterController;

    public String execute() throws Exception {
        this.filter = this.buildResultsFilterFactory.getInstanceWithCookieKey(this.getFilterController().getSelectedFilterKey());
        ImmutablePlan plan = this.getImmutablePlan();
        if (plan == null) {
            this.addActionError(this.getText("viewTestsSummaryForPlan.error.noSuchPlan", new String[]{this.getPlanKey()}));
            return "error";
        }
        List tmpMostFailingTests = this.testsManager.getTopBrokenTests(plan.getPlanKey(), this.filter);
        this.mostFailingTests = tmpMostFailingTests.stream().map(tc -> {
            TestCase testCase = (TestCase)tc.getFirst();
            if (plan instanceof ImmutableJob) {
                return new FailingTestCaseForDisplay(testCase, (Long)tc.getSecond(), (ImmutableJob)plan);
            }
            ImmutableJob job = ChainBranchUtils.findJobByMasterId((ImmutableChain)((ImmutableChain)plan), (long)testCase.getTestClass().getMasterJobId());
            if (job == null) {
                return null;
            }
            return new FailingTestCaseForDisplay(testCase, (Long)tc.getSecond(), job);
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return "success";
    }

    public List<Pair<TestCaseResult, Integer>> getRecentFailures(TestCase testCase, int number) {
        return this.testsManager.getLastNFailingResults(testCase, number);
    }

    public int getFailureBarWidth(int numberOfFailures) {
        if (this.getMaxFailures() > 0L) {
            double failures = numberOfFailures;
            double maxFails = this.getMaxFailures();
            return (int)(failures / maxFails * 100.0);
        }
        return 0;
    }

    private long getMaxFailures() {
        if (this.mostFailingTests != null && !this.mostFailingTests.isEmpty()) {
            FailingTestCaseForDisplay testPair = this.mostFailingTests.get(0);
            return testPair.getFailuresCount();
        }
        return 0L;
    }

    public List<TestCase> getLongestRunningTests() {
        return this.longestRunningTests;
    }

    public List<FailingTestCaseForDisplay> getMostFailingTests() {
        return this.mostFailingTests;
    }

    public List<Pair<TestCase, Float>> getLongestTimeToFixTests() {
        return this.longestTimeToFixTests;
    }

    @ParameterSafe
    public FilterController getFilterController() {
        return this.filterController;
    }

    public void setFilterController(FilterController filterController) {
        this.filterController = filterController;
    }

    public void setBuildResultsFilterFactory(BuildResultsFilterFactory buildResultsFilterFactory) {
        this.buildResultsFilterFactory = buildResultsFilterFactory;
    }

    public void setTestsManager(TestsManager testsManager) {
        this.testsManager = testsManager;
    }
}

