/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.tests;

import com.atlassian.bamboo.build.FilterController;
import com.atlassian.bamboo.build.tests.FailingTestCaseForDisplay;
import com.atlassian.bamboo.builder.resultsfilter.AllBuildResultsFilter;
import com.atlassian.bamboo.builder.resultsfilter.BuildResultsFilter;
import com.atlassian.bamboo.builder.resultsfilter.BuildResultsFilterFactory;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.reports.collector.ReportCollector;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.tests.TestCase;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResult;
import com.atlassian.bamboo.resultsummary.tests.TestsManager;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.ww2.actions.BuildActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.PlanReadSecurityAware;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.xwork.ParameterSafe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.jfree.data.xy.XYDataset;

public class ViewTestsSummary
extends BuildActionSupport
implements PlanReadSecurityAware {
    private static final Logger log = Logger.getLogger(ViewTestsSummary.class);
    private List<FailingTestCaseForDisplay> mostFailingTests = new ArrayList<FailingTestCaseForDisplay>();
    private List<TestCase> longestRunningTests = new ArrayList<TestCase>();
    private List<Pair<TestCase, Float>> longestTimeToFixTests = new ArrayList<Pair<TestCase, Float>>();
    private BuildResultsFilter filter;
    private List<BuildResultsSummary> filteredBuildResults = new ArrayList<BuildResultsSummary>();
    private XYDataset dataset;
    private String reportKey = "com.atlassian.bamboo.plugin.system.reports:numberOfTests";
    private TestsManager testsManager;
    private PluginAccessor pluginAccessor;
    private BuildResultsFilterFactory buildResultsFilterFactory;
    private FilterController filterController;

    public String execute() throws Exception {
        if (this.getImmutableBuild() == null) {
            this.addActionError("Could not find the \"" + this.getBuildKey() + "\" build");
            return "error";
        }
        this.filter = this.buildResultsFilterFactory.getInstanceWithCookieKey(this.getFilterController().getSelectedFilterKey());
        this.filteredBuildResults = this.filter.getBuildResultsForBuild(this.getImmutableBuild());
        this.longestRunningTests = this.testsManager.getLongestRunningTestCases((ImmutablePlan)this.getImmutableBuild());
        if (!this.filteredBuildResults.isEmpty()) {
            List tmpMostFailingTests;
            if (this.filter instanceof AllBuildResultsFilter) {
                tmpMostFailingTests = this.testsManager.getMostFailingTestCases((ImmutablePlan)this.getImmutableBuild());
                this.longestTimeToFixTests = this.testsManager.getLongestToFixTestCases((ImmutablePlan)this.getImmutableBuild());
            } else {
                tmpMostFailingTests = this.testsManager.getMostFailingTestCases(this.filteredBuildResults);
                this.longestTimeToFixTests = this.testsManager.getLongestToFixTestCases(this.filteredBuildResults);
            }
            this.mostFailingTests = tmpMostFailingTests.stream().map(tc -> {
                TestCase testCase = (TestCase)tc.getFirst();
                return new FailingTestCaseForDisplay(testCase, (Long)tc.getSecond(), (ImmutableJob)this.getImmutableBuild());
            }).collect(Collectors.toList());
            ModuleDescriptor descriptor = this.pluginAccessor.getPluginModule(this.getReportKey());
            if (descriptor != null) {
                ReportCollector collector = (ReportCollector)descriptor.getModule();
                collector.setResultsList(this.filteredBuildResults);
                collector.setParams(Collections.emptyMap());
                this.dataset = (XYDataset)collector.getDataset();
            }
        }
        return super.execute();
    }

    public List<Pair<TestCaseResult, Integer>> getRecentFailures(TestCase testCase, int number) {
        if (this.filter instanceof AllBuildResultsFilter) {
            return this.testsManager.getLastNFailingResults(testCase, number);
        }
        return this.testsManager.getLastNFailingResults(testCase, this.filteredBuildResults, number);
    }

    public int getFailureBarWidth(int numberOfFailures) {
        if (this.getMaxFailures() > 0L) {
            double failures = numberOfFailures;
            double maxFails = this.getMaxFailures();
            return (int)(failures / maxFails * 100.0);
        }
        return 0;
    }

    private long getMaxFailures() {
        if (this.mostFailingTests != null && !this.mostFailingTests.isEmpty()) {
            FailingTestCaseForDisplay testPair = this.mostFailingTests.get(0);
            return testPair.getFailuresCount();
        }
        return 0L;
    }

    public List<TestCase> getLongestRunningTests() {
        return this.longestRunningTests;
    }

    public List<FailingTestCaseForDisplay> getMostFailingTests() {
        return this.mostFailingTests;
    }

    public List<Pair<TestCase, Float>> getLongestTimeToFixTests() {
        return this.longestTimeToFixTests;
    }

    @ParameterSafe
    public FilterController getFilterController() {
        return this.filterController;
    }

    public void setFilterController(FilterController filterController) {
        this.filterController = filterController;
    }

    public XYDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(XYDataset dataset) {
        this.dataset = dataset;
    }

    public String getReportKey() {
        return this.reportKey;
    }

    public void setReportKey(String reportKey) {
        this.reportKey = reportKey;
    }

    public void setBuildResultsFilterFactory(BuildResultsFilterFactory buildResultsFilterFactory) {
        this.buildResultsFilterFactory = buildResultsFilterFactory;
    }

    public void setTestsManager(TestsManager testsManager) {
        this.testsManager = testsManager;
    }

    @Override
    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }
}

