/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.tests;

import com.atlassian.bamboo.build.FilterController;
import com.atlassian.bamboo.builder.resultsfilter.AllBuildResultsFilter;
import com.atlassian.bamboo.builder.resultsfilter.BuildResultsFilter;
import com.atlassian.bamboo.builder.resultsfilter.BuildResultsFilterFactory;
import com.atlassian.bamboo.builder.resultsfilter.BuildResultsFilterFactoryImpl;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.resultsummary.tests.TestCase;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResult;
import com.atlassian.bamboo.resultsummary.tests.TestCaseSummary;
import com.atlassian.bamboo.resultsummary.tests.TestCaseSummaryImpl;
import com.atlassian.bamboo.resultsummary.tests.TestState;
import com.atlassian.bamboo.resultsummary.tests.TestsManager;
import com.atlassian.bamboo.ww2.actions.BuildActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.PlanReadSecurityAware;
import com.atlassian.xwork.ParameterSafe;
import org.apache.log4j.Logger;

public class ViewTestCaseAction
extends BuildActionSupport
implements PlanReadSecurityAware {
    private static final Logger log = Logger.getLogger(ViewTestCaseAction.class);
    private long testCaseId = -1L;
    private TestCase testCase;
    private TestCaseSummary testCaseSummary;
    private FilterController filterController;
    private TestsManager testsManager;
    private BuildResultsFilterFactory buildResultsFilterFactory;
    private TestState latestTestCaseState;

    public String input() throws Exception {
        if (this.cachedPlanManager.getPlanByKey(PlanKeys.getChainKeyIfJobKey((PlanKey)this.getTypedPlanKey())) == null) {
            this.addActionError("Could not find the \"" + this.getBuildKey() + "\" build");
            return "error";
        }
        this.testCase = this.testsManager.getTestCaseById(this.testCaseId);
        if (this.testCase == null) {
            this.addActionError("This test case could not be found.");
            return "error";
        }
        BuildResultsFilter filter = this.buildResultsFilterFactory.getInstanceWithCookieKey(this.getFilterController().getSelectedFilterKey());
        this.testCaseSummary = filter instanceof AllBuildResultsFilter ? new TestCaseSummaryImpl(this.testCase, this.getTypedPlanKey(), null, this.testsManager, this.resultsSummaryManager) : new TestCaseSummaryImpl(this.testCase, this.getTypedPlanKey(), filter.getBuildResultsForBuild(this.getImmutableBuild()), this.testsManager, this.resultsSummaryManager);
        TestCaseResult latestTestCaseResult = this.testCaseSummary.getLastTestCaseResult();
        this.latestTestCaseState = latestTestCaseResult != null ? latestTestCaseResult.getState() : TestState.SUCCESS;
        return "input";
    }

    public void setFilterController(FilterController filterController) {
        this.filterController = filterController;
    }

    @ParameterSafe
    public FilterController getFilterController() {
        return this.filterController;
    }

    public TestCase getTestCase() {
        return this.testCase;
    }

    public TestCaseSummary getTestCaseSummary() {
        return this.testCaseSummary;
    }

    public TestState getLatestTestCaseState() {
        return this.latestTestCaseState;
    }

    public long getTestCaseId() {
        return this.testCaseId;
    }

    public void setTestCaseId(long testCaseId) {
        this.testCaseId = testCaseId;
    }

    public void setBuildResultsFilterFactory(BuildResultsFilterFactoryImpl buildResultsFilterFactory) {
        this.buildResultsFilterFactory = buildResultsFilterFactory;
    }

    public void setTestsManager(TestsManager testsManager) {
        this.testsManager = testsManager;
    }
}

