/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.monitoring;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.build.monitoring.ForceBuildStopperUtil;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.configuration.MiscellaneousPlanConfigurationPlugin;
import com.atlassian.bamboo.v2.build.BaseBuildConfigurationAwarePlugin;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.bandana.BandanaManager;
import java.util.Map;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HungBuildPlanConfigurationPlugin
extends BaseBuildConfigurationAwarePlugin
implements MiscellaneousPlanConfigurationPlugin {
    private static final Logger log = Logger.getLogger(HungBuildPlanConfigurationPlugin.class);
    @Inject
    private AdministrationConfigurationAccessor administrationConfigurationAccessor;
    @Inject
    private BandanaManager bandanaManager;

    public boolean isApplicableTo(@NotNull ImmutablePlan plan) {
        return !(plan instanceof Job);
    }

    protected void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull BuildConfiguration buildConfiguration, @Nullable Plan plan) {
        if (plan != null) {
            this.populateContext(context, plan);
        }
    }

    protected void populateContextForView(@NotNull Map<String, Object> context, @NotNull Plan plan) {
        this.populateContext(context, plan);
    }

    public void prepareConfigObject(@NotNull BuildConfiguration buildConfiguration) {
        if (buildConfiguration.getProperty("custom.com.atlassian.bamboo.plugin.hungbuildkiller.hung.enabled") == null) {
            buildConfiguration.setProperty("custom.com.atlassian.bamboo.plugin.hungbuildkiller.hung.enabled", (Object)ForceBuildStopperUtil.getBandanaValue(this.bandanaManager, "custom.com.atlassian.bamboo.plugin.hungbuildkiller.hung.enabled.global"));
        }
    }

    public void addDefaultValues(@NotNull BuildConfiguration buildConfiguration) {
        if (buildConfiguration.getProperty("custom.com.atlassian.bamboo.plugin.hungbuildkiller.hung.enabled") == null) {
            log.info((Object)"setting default values for edit page. custom.com.atlassian.bamboo.plugin.hungbuildkiller.hung.enabled");
            buildConfiguration.setProperty("custom.com.atlassian.bamboo.plugin.hungbuildkiller.hung.enabled", (Object)"true");
        }
        super.addDefaultValues(buildConfiguration);
    }

    public boolean isConfigurationMissing(@NotNull BuildConfiguration buildConfiguration) {
        return buildConfiguration.getProperty("custom.com.atlassian.bamboo.plugin.hungbuildkiller.hung.enabled") == null;
    }

    private void populateContext(@NotNull Map<String, Object> context, @NotNull Plan plan) {
        context.put("custom.com.atlassian.bamboo.plugin.hungbuildkiller.hung.available", !this.administrationConfigurationAccessor.getAdministrationConfiguration().getBuildHangingConfig().isDisabled());
        context.put("custom.com.atlassian.bamboo.plugin.hungbuildkiller.hung.enabled", ForceBuildStopperUtil.isCustomConfigurationEnabledForPlan(plan.getBuildDefinition(), "custom.com.atlassian.bamboo.plugin.hungbuildkiller.hung.enabled", true));
    }
}

