/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.monitoring;

import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ForceBuildStopperUtil {
    private static final Logger log = Logger.getLogger(ForceBuildStopperUtil.class);

    public static Boolean getBandanaValue(BandanaManager bandanaManager, String key) {
        Object o = bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, key);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return Boolean.parseBoolean(StringUtils.defaultString((String)((String)o), (String)"true"));
    }

    public static boolean isCustomConfigurationEnabledForPlan(@NotNull BuildDefinition buildDefinition, String key, boolean defaultValue) {
        boolean isEnabled;
        Map customConfiguration = buildDefinition.getCustomConfiguration();
        if (customConfiguration.containsKey(key)) {
            log.info((Object)("Custom configuration for key:" + key + " = " + (String)customConfiguration.get(key)));
            isEnabled = Boolean.parseBoolean(StringUtils.defaultString((String)((String)customConfiguration.get(key)), (String)"true"));
        } else {
            log.info((Object)("Custom configuration doesn't contain:" + key));
            isEnabled = defaultValue;
            customConfiguration.put(key, Boolean.toString(isEnabled));
            buildDefinition.setCustomConfiguration(customConfiguration);
        }
        return isEnabled;
    }
}

