/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.monitoring;

import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.monitoring.ForceBuildStopperUtil;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.comment.CommentService;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.event.BuildCanceledEvent;
import com.atlassian.bamboo.event.BuildHungEvent;
import com.atlassian.bamboo.event.PlanEvent;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ResultDataRead;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.agent.AgentCommandSender;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.agent.LocalBuildAgent;
import com.atlassian.bamboo.v2.build.agent.messages.ManageHungBuildMessage;
import com.atlassian.bamboo.v2.build.agent.messages.RemoteBambooMessage;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.struts.TextProvider;
import com.atlassian.user.User;
import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ForceBuildStopper {
    static final String FORCE_STOP_BUILD_FEATURE_AVAILABLE = "custom.com.atlassian.bamboo.plugin.hungbuildkiller.hung.available";
    @Inject
    private CommentService commentService;
    @Inject
    private ResultsSummaryManager resultsSummaryManager;
    @Inject
    private AgentManager agentManager;
    @Inject
    private AgentCommandSender agentCommandSender;
    @Inject
    private CachedPlanManager cachedPlanManager;
    @Inject
    private BandanaManager bandanaManager;
    @Inject
    private TextProvider textProvider;
    private static final Logger log = Logger.getLogger(ForceBuildStopper.class);

    @EventListener
    public void onBuildCancelled(BuildCanceledEvent event) {
        log.info((Object)("Handling event " + event));
        BuildDefinition buildDefinition = this.getBuildDefinition((PlanEvent)event);
        if (buildDefinition == null) {
            log.warn((Object)"Could not retrieve configuration for this plan. Automatic Hung Build detection disabled.");
            return;
        }
        if (!this.isEnabledForBuild(buildDefinition)) {
            return;
        }
        log.info((Object)"canceled build detected");
        this.manageCancelledProcess(event);
    }

    @EventListener
    public void onBuildHung(BuildHungEvent event) {
        log.info((Object)("Handling event " + event));
        BuildDefinition buildDefinition = this.getBuildDefinition((PlanEvent)event);
        if (buildDefinition == null) {
            log.warn((Object)"Could not retrieve configuration for this plan. Automatic Hung Build detection disabled.");
            return;
        }
        if (!this.isEnabledForBuild(buildDefinition)) {
            return;
        }
        log.info((Object)"hung build detected");
        PlanResultKey planResultKey = PlanKeys.getPlanResultKey((PlanKey)event.getPlanKey(), (int)event.getBuildNumber());
        this.addComment(this.textProvider.getText("bamboo.build.monitoring.hung.comment"), planResultKey);
        this.manageHungProcess(event, planResultKey);
    }

    private boolean isEnabledForBuild(BuildDefinition buildDefinition) {
        if (!ForceBuildStopperUtil.isCustomConfigurationEnabledForPlan(buildDefinition, "custom.com.atlassian.bamboo.plugin.hungbuildkiller.hung.enabled", true)) {
            log.info((Object)"ForceBuildStopper feature is not enabled in this plan for hung builds.");
            return false;
        }
        if (!ForceBuildStopperUtil.getBandanaValue(this.bandanaManager, "custom.com.atlassian.bamboo.plugin.hungbuildkiller.hung.enabled.global").booleanValue()) {
            log.info((Object)"ForceBuildStopper feature is not enabled in this Bamboo instance for hung builds.");
            return false;
        }
        return true;
    }

    @Nullable
    public BuildDefinition getBuildDefinition(PlanEvent event) {
        try {
            PlanKey planKey = event.getPlanKey();
            log.info((Object)("getting the build definition from key: " + planKey));
            ImmutablePlan plan = this.cachedPlanManager.getPlanByKey(planKey);
            ImmutableJob job = (ImmutableJob)Narrow.to((Object)plan, ImmutableJob.class);
            if (job != null) {
                return job.getParent().getBuildDefinition();
            }
        }
        catch (Exception e) {
            log.error((Object)("error getting plan info. Message: " + e.getMessage()));
            log.error((Object)("stack trace: : " + Arrays.toString(e.getStackTrace())));
        }
        return null;
    }

    @VisibleForTesting
    void addComment(String content, PlanResultKey planResultKey) {
        ResultsSummary resultsSummary = this.resultsSummaryManager.getResultsSummary(planResultKey, ResultDataRead.EAGER);
        if (resultsSummary == null) {
            log.error((Object)("can't get result summary for " + planResultKey));
            return;
        }
        ForceBuildStopperUser user = new ForceBuildStopperUser("forceBuildStopper");
        log.info((Object)"adding hung build comment");
        this.commentService.addComment(content, (User)user, (BambooIdProvider)resultsSummary);
        log.debug((Object)"comment added");
    }

    @VisibleForTesting
    void manageHungProcess(BuildHungEvent buildEvent, PlanResultKey planResultKey) {
        this.manageRemoteBuild(buildEvent.getCurrentlyBuilding().getBuildAgentId(), planResultKey);
    }

    @VisibleForTesting
    void manageCancelledProcess(BuildCanceledEvent buildEvent) {
        PlanResultKey planResultKey = PlanKeys.getPlanResultKey((PlanKey)buildEvent.getPlanKey(), (int)buildEvent.getBuildNumber());
        this.manageRemoteBuild(buildEvent.getAgentId(), planResultKey);
    }

    private void manageRemoteBuild(Long agentId, final PlanResultKey planResultKey) {
        if (agentId == null) {
            log.warn((Object)"Bamboo didn't return the agent id for this build-event so we can't proceed...");
            return;
        }
        log.info((Object)("agent id is: " + agentId));
        final BuildAgent buildAgent = this.agentManager.getAgent(agentId.longValue());
        log.info((Object)("agentCommandSender: " + this.agentCommandSender));
        if (buildAgent != null) {
            buildAgent.accept(new BuildAgent.BuildAgentVisitor(){

                public void visitLocal(LocalBuildAgent localBuildAgent) {
                    log.info((Object)("Force Stop feature doesn't work for builds started at local agent. Affected plan: " + planResultKey));
                }

                public void visitRemote(BuildAgent remoteBuildAgent) {
                    log.info((Object)"sending command to remote agent");
                    ForceBuildStopper.this.agentCommandSender.send((RemoteBambooMessage)new ManageHungBuildMessage(planResultKey), Long.valueOf(buildAgent.getId()));
                }
            });
        } else {
            log.error((Object)("can't get a build agent with the id: " + agentId));
        }
    }

    private static class ForceBuildStopperUser
    implements User {
        private static final String DEFAULT_USER_EMAIL = "bamboo@example.com";
        private final String name;

        private ForceBuildStopperUser(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getFullName() {
            return "user";
        }

        public String getEmail() {
            return DEFAULT_USER_EMAIL;
        }

        public boolean isEnabled() {
            return true;
        }

        public void setFullName(String fullName) {
        }

        public void setEmail(String email) {
        }

        public void setPassword(String password) {
        }
    }
}

