/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.monitoring;

import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.build.monitoring.BuildHangingConfig;
import com.atlassian.bamboo.build.monitoring.ForceBuildStopperUtil;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalAdminSecurityAware;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import javax.inject.Inject;

public class ConfigureGlobalBuildHangingDetection
extends BambooActionSupport
implements GlobalAdminSecurityAware {
    @Inject
    private BandanaManager bandanaManager;
    private double multiplier;
    private int minutesBeforeQueueTimeout;
    private int minutesBetweenLogs;
    private boolean enableBuildMonitoring;
    private boolean enableForceStop;
    private boolean configurationUpdated;
    private boolean enableLiveLogs;

    public void validate() {
        if (this.minutesBetweenLogs <= 0) {
            this.addFieldError("minutesBetweenLogs", this.getText("buildMonitoring.force.stop.error.minutesBetweenLogs.required"));
        }
        if (this.multiplier <= 0.0) {
            this.addFieldError("multiplier", this.getText("buildMonitoring.force.stop.error.multiplier.required"));
        }
        if (this.minutesBeforeQueueTimeout <= 0) {
            this.addFieldError("minutesBeforeQueueTimeout", this.getText("buildMonitoring.force.stop.error.minutesBeforeQueueTimeout.required"));
        }
    }

    public String input() throws Exception {
        BuildHangingConfig buildHangingConfig = new BuildHangingConfig(this.getAdministrationConfiguration().getBuildHangingConfig());
        this.multiplier = buildHangingConfig.getMultiplier();
        this.minutesBeforeQueueTimeout = buildHangingConfig.getMinutesBeforeQueueTimeout();
        this.minutesBetweenLogs = buildHangingConfig.getMinutesBetweenLogs();
        this.enableBuildMonitoring = !buildHangingConfig.isDisabled();
        this.enableLiveLogs = !this.featureManager.isArtifactsAsLogsEnabled() || buildHangingConfig.isLiveLogsAreActive();
        this.enableForceStop = ForceBuildStopperUtil.getBandanaValue(this.bandanaManager, "custom.com.atlassian.bamboo.plugin.hungbuildkiller.hung.enabled.global");
        return super.input();
    }

    public String execute() throws Exception {
        AdministrationConfiguration administrationConfiguration = this.getAdministrationConfiguration();
        this.updateBuildHangingConfig(administrationConfiguration);
        this.administrationConfigurationPersister.saveAdministrationConfiguration(administrationConfiguration);
        this.bandanaManager.setValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, "custom.com.atlassian.bamboo.plugin.hungbuildkiller.hung.enabled.global", (Object)(this.enableBuildMonitoring && this.enableForceStop ? 1 : 0));
        this.configurationUpdated = true;
        return "success";
    }

    public boolean isEnableBuildMonitoring() {
        return this.enableBuildMonitoring;
    }

    public void setEnableBuildMonitoring(boolean enableBuildMonitoring) {
        this.enableBuildMonitoring = enableBuildMonitoring;
    }

    public boolean isEnableForceStop() {
        return this.enableForceStop;
    }

    public void setEnableForceStop(boolean enableForceStop) {
        this.enableForceStop = enableForceStop;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(double multiplier) {
        this.multiplier = multiplier;
    }

    public boolean isEnableLiveLogs() {
        return this.enableLiveLogs;
    }

    public void setEnableLiveLogs(boolean enableLiveLogs) {
        this.enableLiveLogs = enableLiveLogs;
    }

    public int getMinutesBeforeQueueTimeout() {
        return this.minutesBeforeQueueTimeout;
    }

    public void setMinutesBeforeQueueTimeout(int minutesBeforeQueueTimeout) {
        this.minutesBeforeQueueTimeout = minutesBeforeQueueTimeout;
    }

    public int getMinutesBetweenLogs() {
        return this.minutesBetweenLogs;
    }

    public void setMinutesBetweenLogs(int minutesBetweenLogs) {
        this.minutesBetweenLogs = minutesBetweenLogs;
    }

    public boolean isConfigurationUpdated() {
        return this.configurationUpdated;
    }

    private void updateBuildHangingConfig(AdministrationConfiguration administrationConfiguration) {
        BuildHangingConfig buildHangingConfig = new BuildHangingConfig(administrationConfiguration.getBuildHangingConfig());
        buildHangingConfig.setDisabled(!this.enableBuildMonitoring);
        buildHangingConfig.setMultiplier(this.multiplier);
        buildHangingConfig.setMinutesBetweenLogs(this.minutesBetweenLogs);
        buildHangingConfig.setMinutesBeforeQueueTimeout(this.minutesBeforeQueueTimeout);
        buildHangingConfig.setLiveLogsAreActive(this.enableLiveLogs || !this.featureManager.isArtifactsAsLogsEnabled());
        administrationConfiguration.setBuildHangingConfig(buildHangingConfig);
    }
}

