/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.expiry;

import com.atlassian.bamboo.build.expiry.BuildExpiryBean;
import com.atlassian.bamboo.build.expiry.BuildExpiryConfig;
import com.atlassian.bamboo.build.expiry.BuildExpiryType;
import com.atlassian.bamboo.build.expiry.CombinedExpiryConfig;
import com.atlassian.bamboo.build.expiry.ExpiryScheduler;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationImpl;
import com.atlassian.bamboo.deployments.expiry.DeploymentExpiryConfig;
import com.atlassian.bamboo.deployments.expiry.DeploymentExpiryConfigBuilder;
import com.atlassian.bamboo.deployments.expiry.DeploymentExpiryResult;
import com.atlassian.bamboo.deployments.expiry.DeploymentExpiryService;
import com.atlassian.bamboo.security.GlobalApplicationSecureObject;
import com.atlassian.bamboo.utils.BambooFunctions;
import com.atlassian.bamboo.utils.CronUtils;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalAdminSecurityAware;
import com.atlassian.core.cron.generator.CronExpressionDescriptor;
import com.atlassian.core.cron.parser.CronExpressionParser;
import com.atlassian.core.i18n.I18nTextProvider;
import com.atlassian.struts.Preparable;
import com.atlassian.xwork.ParameterSafe;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.opensymphony.xwork2.TextProvider;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Future;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.quartz.Trigger;

public class BuildExpiryAction
extends BambooActionSupport
implements GlobalAdminSecurityAware,
Preparable {
    private static final Logger log = Logger.getLogger(BuildExpiryAction.class);
    private boolean deploymentExpiryEnabled;
    private CombinedExpiryConfig expiryConfig;
    private BuildExpiryConfig globalBuildExpiryConfig;
    private DeploymentExpiryConfig globalDeploymentExpiryConfig;
    private BuildExpiryBean buildExpiryBean;
    private ExpiryScheduler expiryScheduler;
    private DeploymentExpiryService deploymentExpiryService;

    public void prepare() throws Exception {
        AdministrationConfiguration administrationConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration();
        this.deploymentExpiryEnabled = administrationConfiguration.isDeploymentExpiryEnabled();
        this.globalBuildExpiryConfig = administrationConfiguration.getBuildExpiryConfig();
        this.globalDeploymentExpiryConfig = administrationConfiguration.getDeploymentExpiryConfig();
        if (this.expiryConfig == null) {
            this.expiryConfig = new CombinedExpiryConfig(this.globalBuildExpiryConfig, this.globalDeploymentExpiryConfig);
        }
    }

    public void validate() {
        if (this.expiryConfig.isEnabled()) {
            if (this.deploymentExpiryEnabled && this.expiryConfig.getDeploymentsToKeep() < 2) {
                this.addFieldError("expiryConfig.deploymentsToKeep", this.getText("buildExpiry.deploymentsToKeep.error.invalid", (List)ImmutableList.of((Object)2)));
            }
            if (this.deploymentExpiryEnabled && this.expiryConfig.getAnyDeploymentsToKeep() < 0) {
                this.addFieldError("expiryConfig.anyDeploymentsToKeep", this.getText("buildExpiry.duration.error.negative"));
            }
            if (this.expiryConfig.getDuration() < 0) {
                this.addFieldError("expiryConfig.duration", this.getText("buildExpiry.duration.error.negative"));
            }
            if (this.expiryConfig.getBuildsToKeep() < 0) {
                this.addFieldError("expiryConfig.buildsToKeep", this.getText("buildExpiry.buildsToKeep.error.negative"));
            }
            if (this.expiryConfig.getMaximumBuildsToKeep() < 0) {
                this.addFieldError("expiryConfig.maximumBuildsToKeep", this.getText("buildExpiry.buildsToKeep.error.negative"));
            }
            if (this.expiryConfig.getDuration() == 0 && this.expiryConfig.getBuildsToKeep() == 0 && this.expiryConfig.getMaximumBuildsToKeep() == 0) {
                this.addFieldError("expiryConfig.buildsToKeep", this.getText("buildExpiry.buildsToKeep.error.invalid"));
            }
            if (this.expiryConfig.getMaximumBuildsToKeep() > 0 && this.expiryConfig.getBuildsToKeep() > this.expiryConfig.getMaximumBuildsToKeep()) {
                this.addFieldError("expiryConfig.buildsToKeep", this.getText("buildExpiry.minimum.higher.than.maximum"));
            }
            if (!(this.expiryConfig.isExpiryTypeResult() || this.expiryConfig.isExpiryTypeBuildLog() || this.expiryConfig.isExpiryTypeArtifact())) {
                log.warn((Object)"Expiry type not specified. This shouldn't happen.");
                this.addFieldError("expiryConfig.expiryTypeResult", "Expiry type not specified.");
            }
        }
        CronUtils.getCronExpressionValidationError((String)this.expiryConfig.getCronExpression()).ifPresent(error -> this.addFieldError("expiryConfig.cronExpression", (String)error));
    }

    public String read() throws Exception {
        return "read";
    }

    public String run() throws Exception {
        if (this.deploymentExpiryEnabled) {
            int totalDeployments = 0;
            Optional deploymentExpiryResult = this.deploymentExpiryService.triggerDeploymentsExpiration();
            if (deploymentExpiryResult.isPresent()) {
                DeploymentExpiryResult result = (DeploymentExpiryResult)((Future)deploymentExpiryResult.get()).get();
                totalDeployments = result.getAffectedDeploymentsCount();
            }
            long totalBuilds = (Long)this.buildExpiryBean.triggerBuildExpiry().get();
            this.addActionMessage(this.getText("buildExpiry.run.totalBuilds.withDeployments", (List)ImmutableList.of((Object)totalBuilds, (Object)totalDeployments)));
        } else {
            long totalBuilds = (Long)this.buildExpiryBean.triggerBuildExpiry().get();
            this.addActionMessage(this.getText("buildExpiry.run.totalBuilds", Arrays.asList(totalBuilds)));
        }
        return "success";
    }

    public String confirmDeploymentExpiry() {
        return "input";
    }

    public String approveDeploymentExpiry() throws Exception {
        this.deploymentExpiryEnabled = true;
        this.globalDeploymentExpiryConfig = new DeploymentExpiryConfigBuilder(this.globalDeploymentExpiryConfig).withExpiryEnabled().build();
        this.saveConfig();
        return "input";
    }

    public String edit() {
        return "edit";
    }

    public String execute() throws Exception {
        this.expiryConfig.setMaxIgnoredLogSize(this.globalBuildExpiryConfig.getMaxIgnoredLogSize());
        this.globalBuildExpiryConfig = this.expiryConfig.toBuildExpiryConfig();
        this.globalDeploymentExpiryConfig = this.expiryConfig.toDeploymentExpiryConfig();
        this.saveConfig();
        return "success";
    }

    @Override
    public Object getSecuredDomainObject() {
        return GlobalApplicationSecureObject.INSTANCE;
    }

    public String getPrettyCronExpression(String cronExpression) {
        try {
            CronExpressionParser parser = new CronExpressionParser(cronExpression);
            CronExpressionDescriptor descriptor = new CronExpressionDescriptor((I18nTextProvider)this);
            return descriptor.getPrettySchedule(parser.getCronEditorBean());
        }
        catch (Exception e) {
            log.warn((Object)("Exception parsing cron expression: " + cronExpression), (Throwable)e);
            return "Invalid cron expression";
        }
    }

    public String getSelectedExpiryTypesLabel() {
        List labelKeys = this.expiryConfig.getSelectedExpiryTypesLabelKeys(this.deploymentExpiryEnabled);
        List labels = Lists.transform((List)labelKeys, (Function)BambooFunctions.translate((TextProvider)this.getTextProvider()));
        return Joiner.on((String)", ").join((Iterable)labels);
    }

    @Nullable
    public Trigger getTrigger() {
        return this.expiryScheduler.getTrigger();
    }

    public List<BuildExpiryType> getBuildExpiryTypes() {
        return BuildExpiryType.TYPES;
    }

    public String getDefaultCronExpression() {
        return "0 0 0 ? * *";
    }

    private void saveConfig() {
        AdministrationConfiguration administrationConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration();
        administrationConfiguration.setDeploymentExpiryEnabled(this.deploymentExpiryEnabled);
        administrationConfiguration.setDeploymentExpiryConfig(this.globalDeploymentExpiryConfig);
        AdministrationConfigurationImpl.setBuildExpiryConfig((AdministrationConfiguration)administrationConfiguration, (BuildExpiryConfig)this.globalBuildExpiryConfig, (ExpiryScheduler)this.expiryScheduler);
        this.administrationConfigurationPersister.saveAdministrationConfiguration(administrationConfiguration);
    }

    public void setBuildExpiryBean(BuildExpiryBean buildExpiryBean) {
        this.buildExpiryBean = buildExpiryBean;
    }

    public void setExpiryScheduler(ExpiryScheduler expiryScheduler) {
        this.expiryScheduler = expiryScheduler;
    }

    public void setDeploymentExpiryService(DeploymentExpiryService deploymentExpiryService) {
        this.deploymentExpiryService = deploymentExpiryService;
    }

    public boolean isDeploymentExpiryEnabled() {
        return this.deploymentExpiryEnabled;
    }

    @ParameterSafe
    public CombinedExpiryConfig getExpiryConfig() {
        return this.expiryConfig;
    }

    public void setExpiryConfig(CombinedExpiryConfig expiryConfig) {
        this.expiryConfig = expiryConfig;
    }

    public String getMaxIgnoredLogSizeFormatted() {
        return FileUtils.byteCountToDisplaySize((long)this.getExpiryConfig().getMaxIgnoredLogSize());
    }
}

