/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.build.ViewBuildResults;
import com.atlassian.bamboo.results.BuildResults;
import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.resultsummary.tests.TestCase;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResult;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultImpl;
import com.atlassian.bamboo.resultsummary.tests.TestClassResult;
import com.atlassian.bamboo.resultsummary.tests.TestClassResultImpl;
import com.atlassian.bamboo.resultsummary.tests.TestDeltaState;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.log4j.Logger;

public class ViewTestCaseResultAction
extends ViewBuildResults {
    private static final Logger log = Logger.getLogger(ViewTestCaseResultAction.class);
    public static final String NO_RESULT = "noResult";
    private long testCaseId = -1L;
    private String methodName;
    private List<TestCaseResult> testCaseResults;

    @Override
    public String execute() throws Exception {
        String superReturn = super.execute();
        if (superReturn.equals("error")) {
            return "error";
        }
        TestCase testCase = this.testsManager.getTestCaseById(this.testCaseId);
        if (testCase == null) {
            this.addActionError(this.getText("buildResult.testCase.noTestCase", Lists.newArrayList((Object[])new Long[]{this.testCaseId})));
            return "error";
        }
        this.setMethodName(testCase.getMethodName());
        this.testCaseResults = this.testsManager.getTestCaseResults(testCase, (long)this.getBuildNumber().intValue());
        if (this.testCaseResults.isEmpty()) {
            Map successfulTestsMap;
            TestResults tr;
            BuildResults buildResults = this.getBuildResults();
            if (buildResults != null && buildResults.getSuccessfulTestResultsMap() != null && (tr = (TestResults)(successfulTestsMap = buildResults.getSuccessfulTestResultsMap()).get(this.testCaseId)) != null) {
                TestCaseResultImpl singleTestCaseResult = new TestCaseResultImpl(testCase, tr.getDurationMs(), tr.getState());
                singleTestCaseResult.setDeltaState(TestDeltaState.PASSING);
                TestClassResultImpl tcr = new TestClassResultImpl(testCase.getTestClass(), this.getBuildResultsSummary());
                singleTestCaseResult.setTestClassResult((TestClassResult)tcr);
                this.testCaseResults = Lists.newArrayList((Object[])new TestCaseResult[]{singleTestCaseResult});
            }
            if (this.testCaseResults.isEmpty()) {
                return NO_RESULT;
            }
        }
        return "success";
    }

    public List<TestClassResult> getTestClassResults() {
        if (CollectionUtils.isEmpty(this.testCaseResults)) {
            return null;
        }
        ArrayList<TestClassResult> testClassResults = new ArrayList<TestClassResult>();
        for (TestCaseResult testCaseResult : this.testCaseResults) {
            testClassResults.add(testCaseResult.getTestClassResult());
        }
        return testClassResults;
    }

    public List<TestCaseResult> getTestCaseResults() {
        return this.testCaseResults;
    }

    public long getTestCaseId() {
        return this.testCaseId;
    }

    public void setTestCaseId(long testCaseId) {
        this.testCaseId = testCaseId;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getMethodName() {
        return this.methodName;
    }
}

