/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.build.ViewBuildResults;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.util.UrlUtils;

public class ViewPreviousBuildResults
extends ViewBuildResults {
    @Override
    public String execute() throws Exception {
        return "success";
    }

    private int getPreviousBuildNumber(ImmutablePlan plan, int currentBuildNumber) {
        int previousBuildNumber = currentBuildNumber;
        ResultsSummary resultsSummary = null;
        int firstBuildNumber = plan.getFirstBuildNumber();
        while (previousBuildNumber >= firstBuildNumber && resultsSummary == null) {
            resultsSummary = this.resultsSummaryManager.getResultsSummary(PlanKeys.getPlanResultKey((String)plan.getKey(), (int)(--previousBuildNumber)));
        }
        return previousBuildNumber;
    }

    @Override
    public String getReturnUrl() {
        String originalReturnUrl = super.getReturnUrl();
        try {
            int intBuildNumber = this.getPreviousBuildNumber(this.getImmutablePlan(), this.getBuildNumber());
            if (originalReturnUrl.toLowerCase().contains("buildnumber=")) {
                return UrlUtils.replaceOrInsertParamValue((String)originalReturnUrl, (String)Integer.toString(intBuildNumber));
            }
            return UrlUtils.replacePlanResultKeyInUrl((String)originalReturnUrl, (PlanKey)this.getImmutablePlan().getPlanKey(), (int)intBuildNumber);
        }
        catch (NumberFormatException e) {
            return originalReturnUrl;
        }
    }
}

