/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.build.ViewBuildResults;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.util.UrlUtils;

public class ViewNextBuildResults
extends ViewBuildResults {
    @Override
    public String execute() throws Exception {
        return "success";
    }

    protected int getNextBuildNumber(ImmutablePlan plan, int currentBuildNumber) {
        int nextBuildNumber = currentBuildNumber;
        ResultsSummary resultsSummary = null;
        while (nextBuildNumber < plan.getLastBuildNumber() && resultsSummary == null) {
            resultsSummary = this.resultsSummaryManager.getResultsSummary(PlanKeys.getPlanResultKey((PlanKey)plan.getPlanKey(), (int)(++nextBuildNumber)));
        }
        return nextBuildNumber;
    }

    @Override
    public String getReturnUrl() {
        String originalReturnUrl = super.getReturnUrl();
        try {
            int intBuildNumber = this.getNextBuildNumber(this.getImmutablePlan(), this.getBuildNumber());
            if (originalReturnUrl.toLowerCase().contains("buildnumber=")) {
                return UrlUtils.replaceOrInsertParamValue((String)originalReturnUrl, (String)Integer.toString(intBuildNumber));
            }
            return UrlUtils.replacePlanResultKeyInUrl((String)originalReturnUrl, (PlanKey)this.getImmutablePlan().getPlanKey(), (int)intBuildNumber);
        }
        catch (NumberFormatException e) {
            return originalReturnUrl;
        }
    }
}

