/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildResultsAction;
import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.build.artifact.ArtifactLinkPredicates;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ContinuableStageHelper;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.StageIdentifier;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionManager;
import com.atlassian.bamboo.plan.artifact.ConsumedSubscription;
import com.atlassian.bamboo.results.warning.BuildWarningSummary;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.tests.FilteredTestResults;
import com.atlassian.bamboo.resultsummary.tests.FilteredTestResultsPaginableImpl;
import com.atlassian.bamboo.resultsummary.warning.BuildResultWarningSummaryManager;
import com.atlassian.bamboo.storage.StorageLocationService;
import com.atlassian.bamboo.util.Narrow;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class ViewBuildResults
extends BuildResultsAction {
    private static final Logger log = Logger.getLogger(ViewBuildResults.class);
    private static final int DEFAULT_DISPLAY_LINES = 25;
    private static final String BAMBOO_MAX_DISPLAY_LINES = "BAMBOO-MAX-DISPLAY-LINES";
    private FilteredTestResults filteredTestResults;
    private Collection<BuildWarningSummary> warnings;
    private Boolean logAccessible;
    private int linesToDisplay;
    private boolean commentMode;
    private Multimap<ResultsSummary, ConsumedSubscription> consumedSubscriptions;
    private Collection<ArtifactLink> artifactLinks;
    private ArtifactSubscriptionManager artifactSubscriptionManager;
    @Autowired(required=false)
    private StorageLocationService storageLocationService;
    @Autowired(required=false)
    private BuildResultWarningSummaryManager buildResultWarningSummaryManager;

    @Override
    public String execute() throws Exception {
        String result = super.execute();
        if ("success".equals(result)) {
            if (this.linesToDisplay <= 0) {
                this.linesToDisplay = NumberUtils.toInt((String)this.cookieCutter.getValueFromCookie(BAMBOO_MAX_DISPLAY_LINES), (int)25);
            }
            if (this.linesToDisplay <= 0) {
                this.linesToDisplay = 25;
            }
            this.cookieCutter.saveValueInCookie(BAMBOO_MAX_DISPLAY_LINES, String.valueOf(this.linesToDisplay));
        }
        return result;
    }

    public boolean isLogAccessible() {
        if (this.logAccessible == null) {
            this.logAccessible = this.storageLocationService.getLogFile((ResultKey)this.getTypedPlanResultKey()).canRead();
        }
        return this.logAccessible;
    }

    public FilteredTestResults getFilteredTestResults() {
        if (this.filteredTestResults == null) {
            this.filteredTestResults = new FilteredTestResultsPaginableImpl(this.getBuildResultsSummary(), 0, 50);
        }
        return this.filteredTestResults;
    }

    public String getArtifactPath() {
        PlanResultKey planResultKey = PlanKeys.getPlanResultKey((String)this.getPlanKey(), (int)this.buildNumber);
        return this.storageLocationService.getDefaultArtifactDirectoryBuilder().getBuildDirectory(planResultKey).getAbsolutePath();
    }

    @Nullable
    public String getSharedArtifactPath() {
        if (PlanKeys.isJobKey((PlanKey)this.getTypedPlanKey())) {
            PlanResultKey planResultKey = PlanKeys.getPlanResultKey((PlanKey)PlanKeys.getChainKeyFromJobKey((PlanKey)this.getTypedPlanKey()), (int)this.buildNumber);
            return this.storageLocationService.getDefaultArtifactDirectoryBuilder().getBuildDirectory(planResultKey).getAbsolutePath();
        }
        return null;
    }

    public Collection<ArtifactLink> getArtifactLinks() {
        if (this.artifactLinks == null) {
            this.artifactLinks = this.buildResultsSummary.getProducedArtifactLinks();
        }
        return this.artifactLinks;
    }

    public boolean jobProducesLocalSharedArtifacts() {
        return this.getArtifactLinks().stream().anyMatch(artifactLink -> ArtifactLinkPredicates.isSharedArtifact((ArtifactLink)artifactLink) && ArtifactLinkPredicates.isAvailableLocally((ArtifactLink)artifactLink));
    }

    public boolean jobHasLocalArtifacts() {
        return this.buildResultsSummary.getArtifactLinks().stream().anyMatch(ArtifactLinkPredicates::isAvailableLocally);
    }

    public boolean jobProducesArtifacts() {
        return !this.buildResultsSummary.getArtifactLinks().isEmpty();
    }

    public Multimap<ResultsSummary, ConsumedSubscription> getConsumedSubscriptions() {
        if (this.consumedSubscriptions == null) {
            this.consumedSubscriptions = this.artifactSubscriptionManager.getConsumedSubscriptions(this.getResultsSummary());
        }
        return this.consumedSubscriptions;
    }

    public boolean isShowSharedArtifactPathInfo() {
        if (StringUtils.isEmpty((CharSequence)this.getSharedArtifactPath())) {
            return false;
        }
        return Iterables.any(this.getArtifactLinks(), ArtifactLinkPredicates::isSharedArtifact) || !this.getConsumedSubscriptions().isEmpty();
    }

    public boolean isShowArtifactPathInfo() {
        return Iterables.any(this.getArtifactLinks(), ArtifactLinkPredicates::isNotSharedArtifact);
    }

    public Collection<BuildWarningSummary> getWarnings() {
        if (this.warnings == null) {
            this.warnings = this.buildResultWarningSummaryManager.findByResultSummary(this.getBuildResultsSummary().getId());
        }
        return this.warnings;
    }

    public long getWarningsCount() {
        return this.getWarnings().stream().mapToLong(warning -> warning.getHighPriorityCount() + warning.getNormalPriorityCount() + warning.getLowPriorityCount()).sum();
    }

    @Override
    public void setAuditLogService(AuditLogService auditLogService) {
        this.auditLogService = auditLogService;
    }

    public int getLinesToDisplay() {
        return this.linesToDisplay;
    }

    public void setLinesToDisplay(int linesToDisplay) {
        this.linesToDisplay = linesToDisplay;
    }

    public boolean isCommentMode() {
        return this.commentMode;
    }

    public void setCommentMode(boolean commentMode) {
        this.commentMode = commentMode;
    }

    public StageIdentifier getStageToRestart() {
        BuildResultsSummary buildResultSumary = (BuildResultsSummary)Narrow.to((Object)this.resultsSummary, BuildResultsSummary.class);
        if (buildResultSumary != null) {
            return ContinuableStageHelper.getStageToRestart(buildResultSumary.getChainResultsSummary());
        }
        return ContinuableStageHelper.getStageToRestart((ChainResultsSummary)this.resultsSummary);
    }

    public void setArtifactSubscriptionManager(ArtifactSubscriptionManager artifactSubscriptionManager) {
        this.artifactSubscriptionManager = artifactSubscriptionManager;
    }
}

