/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.ViewBuildResults;
import com.atlassian.bamboo.build.logger.BuildLogFileAccessor;
import com.atlassian.bamboo.build.logger.BuildLogFileAccessorFactory;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.storage.StorageLocationService;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ViewBuildLogs
extends ViewBuildResults {
    private static final Logger log = Logger.getLogger(ViewBuildLogs.class);
    private List<LogEntry> buildLogs = new ArrayList<LogEntry>();
    private boolean buildLogsTooLong;
    private static final int MAX_LINES_TO_SHOW = 1000;
    private long totalLines;
    private BuildLogFileAccessorFactory buildLogFileAccessorFactory;
    private StorageLocationService storageLocationService;

    @Override
    public String execute() throws Exception {
        String superResult = super.execute();
        if ("error".equals(superResult)) {
            return "error";
        }
        this.retrieveBuildLogs(PlanKeys.getPlanKey((String)this.getPlanKey()));
        return superResult;
    }

    public List<String> getOldLogsFileNames() {
        return this.storageLocationService.getOldLogsFileNames((ResultKey)this.getTypedPlanResultKey());
    }

    private void retrieveBuildLogs(PlanKey planKey) {
        try {
            BuildLogFileAccessor fileAccessor = this.buildLogFileAccessorFactory.createBuildLogFileAccessor((Key)planKey, this.buildResultsSummary.getBuildNumber());
            this.buildLogs = fileAccessor.getLastNLogs(1000);
            this.buildLogsTooLong = this.buildLogs.size() >= 1000;
            this.totalLines = fileAccessor.getNumberOfLinesInFile();
        }
        catch (Exception e) {
            log.error((Object)("Failed to load build logs for build " + planKey + "-" + (this.buildResults != null ? Integer.valueOf(this.buildResults.getBuildNumber()) : null)), (Throwable)e);
        }
    }

    public List<LogEntry> getBuildLogs() {
        return this.buildLogs;
    }

    public int getMaxLinesToShow() {
        return 1000;
    }

    public long getTotalLines() {
        return this.totalLines;
    }

    public boolean isBuildLogsTooLong() {
        return this.buildLogsTooLong;
    }

    public void setBuildLogFileAccessorFactory(BuildLogFileAccessorFactory buildLogFileAccessorFactory) {
        this.buildLogFileAccessorFactory = buildLogFileAccessorFactory;
    }

    public void setStorageLocationService(StorageLocationService storageLocationService) {
        this.storageLocationService = storageLocationService;
    }
}

