/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.persister.xstream.RelativePath;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.agent.LocalBuildAgent;
import com.atlassian.bamboo.ww2.actions.BuildActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.PlanReadSecurityAware;
import com.atlassian.core.util.FileSize;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ViewBuildFiles
extends BuildActionSupport
implements PlanReadSecurityAware {
    private static final Logger log = Logger.getLogger(ViewBuildFiles.class);
    private File directoryToDisplay;
    private String directoryActionParam;
    private boolean lastBuildLocal = true;
    private File buildWorkingDirectory;
    private AgentManager agentManager;

    public String getDirectory() {
        return this.directoryActionParam;
    }

    public void setDirectory(String value) {
        this.directoryActionParam = value;
    }

    public String execute() throws Exception {
        super.execute();
        try {
            ImmutableResultsSummary summary = this.getImmutableBuild().getLatestResultsSummary();
            if (summary != null) {
                Long agentID = summary.getBuildAgentId();
                if (agentID != null) {
                    BuildAgent agent = this.agentManager.getAgent(agentID.longValue());
                    this.lastBuildLocal = agent instanceof LocalBuildAgent;
                }
                if (this.lastBuildLocal) {
                    String buildWorkingDirectoryString = this.getBuildWorkingDirectory();
                    if (StringUtils.isNotBlank((CharSequence)buildWorkingDirectoryString)) {
                        String suppliedDirectory;
                        this.buildWorkingDirectory = new File(buildWorkingDirectoryString);
                        this.directoryToDisplay = this.directoryActionParam != null ? ((suppliedDirectory = new File(this.directoryActionParam).getCanonicalPath()).startsWith(this.buildWorkingDirectory.getCanonicalPath()) ? new File(this.directoryActionParam) : this.buildWorkingDirectory) : this.buildWorkingDirectory;
                    } else {
                        this.addActionError(this.getText("build.files.repoError"));
                    }
                }
            }
            return "success";
        }
        catch (Exception e) {
            log.error((Object)"Failed to calculate build file directory", (Throwable)e);
            this.addActionError("Failed to calculate build file directory: " + e.getMessage());
            return "error";
        }
    }

    @Nullable
    public String getBuildWorkingDirectory() {
        ImmutableResultsSummary summary = this.getImmutableBuild().getLatestResultsSummary();
        return summary == null ? null : (String)summary.getCustomBuildData().get("working.directory");
    }

    @Nullable
    public File[] getFiles() {
        if (this.directoryToDisplay != null) {
            File[] fileList = this.directoryToDisplay.listFiles();
            if (fileList != null) {
                Arrays.sort(fileList, this::fileEntryComparator);
                return fileList;
            }
            return null;
        }
        return null;
    }

    private int fileEntryComparator(File f1, File f2) {
        if (f1.isDirectory() && f2.isDirectory() || f1.isFile() && f2.isFile()) {
            return f1.compareTo(f2);
        }
        if (f1.isDirectory()) {
            return -1;
        }
        return 1;
    }

    public String formatFileSize(long l) {
        return FileSize.format((long)l);
    }

    public Date formatAsDate(long l) {
        if (l > 0L) {
            return new Date(l);
        }
        return null;
    }

    public List getSourceCodeBreadcrumb() throws Exception {
        ArrayList<ImmutableMap> breadcrumbs = new ArrayList<ImmutableMap>();
        File cursor = new File(this.buildWorkingDirectory, RelativePath.getRelativePath((File)this.buildWorkingDirectory, (File)this.directoryToDisplay));
        while (!cursor.getCanonicalPath().equals(this.buildWorkingDirectory.getCanonicalPath())) {
            breadcrumbs.add(ImmutableMap.of((Object)"file", (Object)cursor, (Object)"relativePath", (Object)RelativePath.getRelativePath((File)this.buildWorkingDirectory, (File)cursor)));
            cursor = cursor.getParentFile();
        }
        Collections.reverse(breadcrumbs);
        return breadcrumbs;
    }

    public boolean isLastBuildLocal() {
        return this.lastBuildLocal;
    }

    public File getSourceDirectory() {
        return this.directoryToDisplay;
    }

    public void setAgentManager(AgentManager agentManager) {
        this.agentManager = agentManager;
    }
}

