/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.build.BuildStatusHelper;
import com.atlassian.bamboo.build.FilterController;
import com.atlassian.bamboo.build.statistics.StatisticsCollector;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.filter.Pager;
import com.atlassian.bamboo.logger.ErrorDetails;
import com.atlassian.bamboo.logger.ErrorHandler;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.v2.build.CurrentlyBuilding;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.ww2.actions.BuildActionSupport;
import com.atlassian.bamboo.ww2.aware.StatisticsAware;
import com.atlassian.bamboo.ww2.aware.permissions.PlanReadSecurityAware;
import com.atlassian.xwork.ParameterSafe;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class ViewBuild
extends BuildActionSupport
implements StatisticsAware,
PlanReadSecurityAware {
    private static final int NUMBER_OF_RESULTS = 10;
    @Autowired
    private ErrorHandler errorHandler;
    private FilterController filterController;
    private List<? extends ResultsSummary> buildResultsList;
    private Collection<ErrorDetails> buildErrors;
    private StatisticsCollector statistics;
    private BuildStatusHelper buildStatusHelper;
    private AgentManager agentManager;
    private ResultsSummary lastSuccessfulSummary;
    private ResultsSummary lastSummary;
    private int lastBuildNumber;
    private Pager pager;

    public void validate() {
        super.validate();
        if (this.getImmutableBuild() == null) {
            this.addActionError(String.format("Could not find the '%s' build", this.getBuildKey()));
        }
    }

    public String execute() throws Exception {
        this.validate();
        if (this.hasErrors()) {
            return "error";
        }
        return "success";
    }

    @Override
    public String doDefault() throws Exception {
        this.validate();
        if (this.hasErrors()) {
            return "error";
        }
        return "input";
    }

    @Override
    public StatisticsCollector getStatistics() {
        return this.statistics;
    }

    @Override
    public void setStatistics(StatisticsCollector statistics) {
        this.statistics = statistics;
    }

    private int getLastBuildNumber() {
        if (this.lastBuildNumber == 0) {
            this.lastBuildNumber = this.getImmutableBuild().getLastBuildNumber();
        }
        return this.lastBuildNumber;
    }

    public BuildStatusHelper getBuildStatusHelper() {
        if (this.buildStatusHelper == null) {
            this.buildStatusHelper = new BuildStatusHelper(this.getImmutableBuild(), PlanKeys.getPlanKey((String)this.getPlanKey()), this.getLastBuildNumber(), this.resultsSummaryManager);
        }
        return this.buildStatusHelper;
    }

    public Collection<ErrorDetails> getBuildErrors() {
        if (this.buildErrors == null) {
            this.buildErrors = this.errorHandler.getErrors((Key)this.getImmutableBuild().getPlanKey());
        }
        return this.buildErrors;
    }

    @ParameterSafe
    public FilterController getFilterController() {
        return this.filterController;
    }

    public void setFilterController(FilterController filterController) {
        this.filterController = filterController;
    }

    @Override
    public List<? extends ResultsSummary> getResultsList() {
        return this.buildResultsList;
    }

    @Override
    public void setResultsList(List<? extends ResultsSummary> results) {
        this.buildResultsList = results;
    }

    @Nullable
    public BuildAgent getAgent(@NotNull CurrentlyBuilding currentlyBuilding) {
        Long buildAgentId = currentlyBuilding.getBuildAgentId();
        return buildAgentId != null ? this.agentManager.getAgent(buildAgentId.longValue()) : null;
    }

    public Pager getPager() {
        if (this.pager == null) {
            this.pager = new Pager();
            this.pager.setPageFromList(this.resultsSummaryManager.getFinalizedResultSummariesForPlan(this.getImmutablePlan().getPlanKey(), BuildResultsSummary.class, 0, 10));
        }
        return this.pager;
    }

    @Nullable
    public ResultsSummary getLastSuccessfulSummary() {
        if (this.lastSuccessfulSummary == null) {
            this.lastSuccessfulSummary = this.resultsSummaryManager.findLastResultSummaryWithState(this.getImmutablePlan().getPlanKey(), BuildState.SUCCESS, ResultsSummary.class);
        }
        return this.lastSuccessfulSummary;
    }

    @Nullable
    public ResultsSummary getLatestSummary() {
        if (this.lastSummary == null) {
            this.lastSummary = this.resultsSummaryManager.getLastResultsSummary(this.getImmutablePlan().getPlanKey().getKey(), ResultsSummary.class);
        }
        return this.lastSummary;
    }

    public void setAgentManager(AgentManager agentManager) {
        this.agentManager = agentManager;
    }
}

