/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.applinks.CredentialsRequiredContextException;
import com.atlassian.bamboo.artifact.Artifact;
import com.atlassian.bamboo.author.ExtendedAuthorManager;
import com.atlassian.bamboo.build.BuildStatusHelper;
import com.atlassian.bamboo.build.artifact.ArtifactHandlingUtils;
import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.build.artifact.ArtifactLinkManager;
import com.atlassian.bamboo.build.test.QuarantineConfiguration;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.chains.ChainExecution;
import com.atlassian.bamboo.chains.ChainExecutionManager;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ChainStageResult;
import com.atlassian.bamboo.chains.ContinuableStageHelper;
import com.atlassian.bamboo.chains.ImmutableChainResultsSummary;
import com.atlassian.bamboo.comment.Comment;
import com.atlassian.bamboo.comment.CommentManager;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueDetails;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueLinkType;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueManager;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueUtils;
import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssue;
import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssueComparator;
import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssueImpl;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.plan.ExecutionStatus;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.StageIdentifier;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.trigger.TriggerManager;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.tests.TestCase;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResult;
import com.atlassian.bamboo.resultsummary.tests.TestClassResult;
import com.atlassian.bamboo.resultsummary.tests.TestQuarantineManager;
import com.atlassian.bamboo.resultsummary.tests.TestsManager;
import com.atlassian.bamboo.resultsummary.variables.ResultsSummaryVariableAccessor;
import com.atlassian.bamboo.resultsummary.vcs.RepositoryChangeset;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.util.PasswordMaskingUtils;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.bamboo.variable.VariableDefinitionContextImpl;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutor;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.viewer.module.VcsRepositoryViewerManager;
import com.atlassian.bamboo.vcs.viewer.runtime.VcsRepositoryViewer;
import com.atlassian.bamboo.ww2.actions.PlanActionSupport;
import com.atlassian.bamboo.ww2.aware.ResultsSummaryAware;
import com.atlassian.bamboo.ww2.aware.permissions.PlanReadSecurityAware;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.xwork2.ActionContext;
import io.atlassian.util.concurrent.LazyReference;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.Period;

public class PlanResultsAction
extends PlanActionSupport
implements ResultsSummaryAware,
PlanReadSecurityAware {
    private static final Logger log = Logger.getLogger(PlanResultsAction.class);
    private static final String HACKED_SORTING_KEY = "hacked.sorting.key";
    protected List<ResultsSummary> neighbouringSummaries;
    protected ExtendedAuthorManager extendedAuthorManager;
    protected TriggerManager triggerManager;
    protected AgentManager agentManager;
    protected JiraIssueManager jiraIssueManager;
    protected JiraIssueUtils jiraIssueUtils;
    protected TestsManager testsManager;
    protected AuditLogService auditLogService;
    protected TestQuarantineManager testQuarantineManager;
    protected BuildStatusHelper buildStatusHelper;
    protected ResultsSummary resultsSummary;
    private boolean isBuildNumberSanitisedViaPlan = false;
    private ChainExecutionManager chainExecutionManager;
    private CommentManager commentManager;
    private boolean oauthAuthenticationRequired = false;
    private URI oauthLoginDanceUrl;
    private String createIssueAppLinkId;
    private String newIssueKey;
    protected ArtifactLinkManager artifactLinkManager;
    private Map<ResultsSummary, ResultsSummary> masterResultsSummariesForTestCases = new HashMap<ResultsSummary, ResultsSummary>();
    private LazyReference<QuarantineConfiguration> quarantineConfiguration = new LazyReference<QuarantineConfiguration>(){

        protected QuarantineConfiguration create() throws Exception {
            return PlanResultsAction.this.administrationConfigurationAccessor.getAdministrationConfiguration().getQuarantineConfiguration();
        }
    };
    protected RepositoryDefinitionManager repositoryDefinitionManager;
    protected VcsRepositoryViewerManager vcsRepositoryViewerManager;
    protected CustomVariableContext customVariableContext;
    private ResultsSummaryVariableAccessor resultsSummaryVariableAccessor;
    private List<Comment> comments;
    private Integer requestedBuildNumber;

    @Override
    public ResultsSummary getResultsSummary() {
        return this.resultsSummary;
    }

    @NotNull
    public List<Comment> getComments() {
        if (this.resultsSummary == null) {
            return Collections.emptyList();
        }
        if (this.comments == null) {
            this.comments = this.commentManager.getCommentsForEntity(this.resultsSummary.getId());
        }
        return this.comments;
    }

    @Override
    public void setResultsSummary(ResultsSummary buildResults) {
        this.resultsSummary = buildResults;
    }

    @Nullable
    public ChainStageResult getPreviousFailedStageResult(BuildResultsSummary buildResultsSummary) {
        ChainStageResult previousFailedStage = null;
        ChainResultsSummary chainResultsSummary = buildResultsSummary.getChainResultsSummary();
        if (chainResultsSummary != null) {
            for (ChainStageResult result : chainResultsSummary.getStageResults()) {
                if (result.getBuildResults().contains(buildResultsSummary)) {
                    return previousFailedStage;
                }
                if (!result.isFailed()) continue;
                previousFailedStage = result;
            }
        }
        return previousFailedStage;
    }

    @Nullable
    public StageIdentifier getStageToContinue() {
        BuildResultsSummary buildResultSumary = (BuildResultsSummary)Narrow.to((Object)this.resultsSummary, BuildResultsSummary.class);
        if (buildResultSumary != null) {
            return ContinuableStageHelper.getStageToContinue(buildResultSumary.getChainResultsSummary());
        }
        return ContinuableStageHelper.getStageToContinue((ChainResultsSummary)this.resultsSummary);
    }

    @NotNull
    public List<ResultsSummary> getNeighbouringSummaries() {
        if (this.neighbouringSummaries == null) {
            this.neighbouringSummaries = this.resultsSummaryManager.getNeighbouringSummaries(this.getImmutablePlan(), this.getBuildNumber().intValue(), 11);
        }
        return this.neighbouringSummaries;
    }

    public String getTriggerReasonLongDescriptionHtml(ResultsSummary resultsSummary) {
        TriggerReason triggerReason = resultsSummary.getTriggerReason();
        return this.triggerManager.getTriggerReasonRenderer(triggerReason, resultsSummary).getLongDescriptionHtml();
    }

    public String getTriggerReasonLongDescriptionText(ResultsSummary resultsSummary) {
        TriggerReason triggerReason = resultsSummary.getTriggerReason();
        return this.triggerManager.getTriggerReasonRenderer(triggerReason, resultsSummary).getShortDescriptionText();
    }

    public Collection<LinkedJiraIssue> getLinkedJiraIssues() {
        return this.resultsSummary.getJiraIssues();
    }

    @NotNull
    public Pair<LinkedJiraIssue, URI> getLinkedJiraIssue(String issueKey) {
        LinkedJiraIssueImpl linkedJiraIssue = new LinkedJiraIssueImpl(issueKey, JiraIssueLinkType.BUILD_RELATES);
        try {
            JiraIssueDetails details = this.jiraIssueManager.getJiraIssueDetails(this.getImmutablePlan().getProject(), issueKey);
            linkedJiraIssue.setJiraIssueDetails(details);
            return Pair.make((Object)linkedJiraIssue, null);
        }
        catch (CredentialsRequiredContextException cre) {
            URI loginDanceUrl = cre.getAuthorisationURI(URI.create(this.getBaseUrl() + this.getCurrentUrl()));
            return Pair.make((Object)linkedJiraIssue, (Object)loginDanceUrl);
        }
        catch (Exception e) {
            log.error((Object)"Unable to get Jira issues", (Throwable)e);
            return Pair.make(null, null);
        }
    }

    @Nullable
    public String getLinkedJiraIssueForTestCase(long testCaseId) {
        TestCase testCase = this.testsManager.getTestCaseById(testCaseId);
        if (testCase == null) {
            return null;
        }
        return testCase.getLinkedJiraIssueKey();
    }

    public Collection<LinkedJiraIssue> getSizeBoundedLinkedJiraIssues(int size) {
        return this.resultsSummary.getJiraIssues().stream().sorted(LinkedJiraIssueComparator.COMPARATOR).limit(size).collect(Collectors.toCollection(ArrayList::new));
    }

    public boolean isHideJiraTeaser() {
        PropertySet properties = this.bambooUserManager.getPropertySet(this.getUser());
        if (properties != null) {
            boolean hideTeaser = Boolean.parseBoolean(properties.getString("bamboo.user.jira.teaser.hide"));
            return hideTeaser;
        }
        return true;
    }

    public List<LinkedJiraIssue> getShortJiraIssues() {
        return this.getShortJiraIssues(2);
    }

    public List<LinkedJiraIssue> getShortJiraIssues(int numberNeeded) {
        return Lists.newLinkedList(this.getIssueDetails(this.jiraIssueUtils.getFilteredJiraIssues(this.getLinkedJiraIssues(), numberNeeded)));
    }

    public List<LinkedJiraIssue> getJiraIssues() {
        return Lists.newLinkedList(this.getIssueDetails(this.getLinkedJiraIssues()));
    }

    public boolean isOauthAuthenticationRequired() {
        return this.oauthAuthenticationRequired;
    }

    public URI getOauthLoginDanceUrl() {
        return this.oauthLoginDanceUrl;
    }

    protected Iterable<LinkedJiraIssue> getIssueDetails(Iterable<LinkedJiraIssue> linkedIssues) {
        try {
            return this.jiraIssueManager.getJiraIssueDetails(this.getImmutablePlan().getProject(), linkedIssues);
        }
        catch (CredentialsRequiredContextException cre) {
            this.oauthAuthenticationRequired = true;
            this.oauthLoginDanceUrl = cre.getAuthorisationURI(URI.create(this.getBaseUrl() + this.getCurrentUrl()));
        }
        catch (Exception e) {
            log.error((Object)"Unable to get Jira issues", (Throwable)e);
        }
        return Collections.emptyList();
    }

    public void setJiraIssueManager(JiraIssueManager jiraIssueManager) {
        this.jiraIssueManager = jiraIssueManager;
    }

    public void setExtendedAuthorManager(ExtendedAuthorManager extendedAuthorManager) {
        this.extendedAuthorManager = extendedAuthorManager;
    }

    public void setTriggerManager(TriggerManager triggerManager) {
        this.triggerManager = triggerManager;
    }

    public void setJiraIssueUtils(JiraIssueUtils jiraIssueUtils) {
        this.jiraIssueUtils = jiraIssueUtils;
    }

    public void setAgentManager(AgentManager agentManager) {
        this.agentManager = agentManager;
    }

    public void setTestsManager(TestsManager testsManager) {
        this.testsManager = testsManager;
    }

    @Override
    public Integer getBuildNumber() {
        if (!this.isBuildNumberSanitisedViaPlan && this.getImmutablePlan() != null) {
            this.buildNumber = this.sanitiseBuildNumber(this.buildNumber);
        }
        return this.buildNumber;
    }

    @Override
    public void setBuildNumber(Integer buildNumber) {
        this.buildNumber = buildNumber;
        this.requestedBuildNumber = buildNumber;
        this.isBuildNumberSanitisedViaPlan = false;
    }

    public Integer getRequestedBuildNumber() {
        return this.requestedBuildNumber;
    }

    public Date getFailStartDate() {
        ResultsSummary previousSuccessfulBuild = this.buildStatusHelper.getPreviousSuccessfulBuild();
        if (previousSuccessfulBuild == null) {
            return null;
        }
        return previousSuccessfulBuild.getBuildDate();
    }

    public boolean isAuditLoggingEnabled() {
        return this.auditLogService.isEnabled();
    }

    public boolean isConfigChanged() {
        BuildStatusHelper buildStatusHelper = this.getBuildStatusHelper();
        ResultsSummary previousSuccessfulBuild = buildStatusHelper.getPreviousSuccessfulBuild();
        if (previousSuccessfulBuild == null) {
            return false;
        }
        Date failStartDate = previousSuccessfulBuild.getBuildDate();
        Date buildDate = this.resultsSummary.getBuildDate();
        if (failStartDate != null && buildDate != null) {
            return this.auditLogService.hasAuditLogMessagesForPlan(this.getImmutablePlan(), failStartDate.getTime(), buildDate.getTime());
        }
        return false;
    }

    public boolean hasDetachedResults() {
        ResultsSummary resultsSummary = this.getResultsSummary();
        ImmutableChainResultsSummary crs = (ImmutableChainResultsSummary)Narrow.downTo((Object)resultsSummary, ImmutableChainResultsSummary.class);
        if (crs != null) {
            ImmutableChain chain = (ImmutableChain)Narrow.downTo((Object)this.getImmutablePlan(), ImmutableChain.class);
            if (chain == null) {
                return false;
            }
            for (ChainStageResult stageResult : crs.getStageResults()) {
                if (chain.getStages().stream().noneMatch(s -> s.getName().equals(stageResult.getName()))) {
                    return true;
                }
                if (!stageResult.getBuildResults().stream().anyMatch(brs -> !brs.getPlanIfExists().isPresent())) continue;
                return true;
            }
            return false;
        }
        return !resultsSummary.getPlanIfExists().isPresent();
    }

    private Integer sanitiseBuildNumber(Integer unsafeBuildNumber) {
        Integer safeBuildNumber;
        if (unsafeBuildNumber == null) {
            log.warn((Object)"Unable to sanitise null build number");
            return null;
        }
        int lowerBound = -1;
        int upperBound = Integer.MAX_VALUE;
        ImmutablePlan plan = this.getImmutablePlan();
        if (plan != null) {
            upperBound = plan.getLastBuildNumber();
            this.isBuildNumberSanitisedViaPlan = true;
        } else {
            log.warn((Object)("Unable to sanitise build number " + unsafeBuildNumber));
        }
        if (unsafeBuildNumber > upperBound) {
            safeBuildNumber = upperBound;
            log.warn((Object)("Build number " + unsafeBuildNumber + " suspiciously high, capping at " + safeBuildNumber));
        } else if (unsafeBuildNumber < lowerBound) {
            safeBuildNumber = lowerBound;
            log.warn((Object)("Build number " + unsafeBuildNumber + " suspiciously low, increasing to " + safeBuildNumber));
        } else {
            safeBuildNumber = unsafeBuildNumber;
        }
        return safeBuildNumber;
    }

    @Nullable
    public TestCaseResult getTestCaseResultOnMasterBranch(@Nullable TestCaseResult testCaseResult) {
        if (testCaseResult != null) {
            BuildResultsSummary resultContainingTest = testCaseResult.getTestClassResult().getBuildResultsSummary();
            ResultsSummary masterResultsSummary = this.masterResultsSummariesForTestCases.computeIfAbsent((ResultsSummary)resultContainingTest, key -> {
                if (key.getImmutableChain().hasMaster()) {
                    ImmutableJob masterJob = (ImmutableJob)this.cachedPlanManager.getPlanById(testCaseResult.getTestClassResult().getTestClass().getMasterJobId(), ImmutableJob.class);
                    if (masterJob != null && !masterJob.isDivergent()) {
                        return (ResultsSummary)Iterables.getOnlyElement((Iterable)this.resultsSummaryManager.getLastNResultsSummaries((ImmutablePlan)masterJob, 1), null);
                    }
                    return null;
                }
                return null;
            });
            if (masterResultsSummary == null) {
                return null;
            }
            for (TestClassResult masterTestClassResult : this.testsManager.getTestClassResults(masterResultsSummary.getPlanResultKey())) {
                if (!((String)Preconditions.checkNotNull((Object)masterTestClassResult.getName())).equals(testCaseResult.getTestClassResult().getName())) continue;
                for (TestCaseResult masterTestCaseResult : masterTestClassResult.getTestCaseResultsSet()) {
                    if (!((String)Preconditions.checkNotNull((Object)masterTestCaseResult.getName())).equals(testCaseResult.getName())) continue;
                    return masterTestCaseResult;
                }
            }
        }
        return null;
    }

    public boolean isSortByDuration() {
        Map session = ActionContext.getContext().getSession();
        if (session != null) {
            Boolean sortByDuration = (Boolean)session.get(HACKED_SORTING_KEY);
            return sortByDuration != null && sortByDuration != false;
        }
        return false;
    }

    public void setSortByDuration(boolean b) {
        ActionContext.getContext().getSession().put(HACKED_SORTING_KEY, b);
    }

    public BuildStatusHelper getBuildStatusHelper() {
        if (this.buildStatusHelper == null) {
            this.buildStatusHelper = new BuildStatusHelper(this.getImmutablePlan(), PlanKeys.getPlanKey((String)this.getPlanKey()), this.getResultsSummary(), this.resultsSummaryManager);
        }
        return this.buildStatusHelper;
    }

    public void setAuditLogService(AuditLogService auditLogService) {
        this.auditLogService = auditLogService;
    }

    public ExecutionStatus getExecutionStatus() {
        return this.planExecutionManager.getExecutionStatus(PlanKeys.getPlanResultKey((String)this.getBuildKey(), (int)this.getBuildNumber()));
    }

    @Nullable
    public ChainExecution getChainExecution() {
        return this.chainExecutionManager.getChainExecution(PlanKeys.getPlanResultKey((String)this.getBuildKey(), (int)this.getBuildNumber()));
    }

    public void setChainExecutionManager(ChainExecutionManager chainExecutionManager) {
        this.chainExecutionManager = chainExecutionManager;
    }

    public void setTestQuarantineManager(TestQuarantineManager testQuarantineManager) {
        this.testQuarantineManager = testQuarantineManager;
    }

    @Override
    @NotNull
    protected Map<String, Object> buildWebPanelContext(@NotNull String location) {
        Map<String, Object> map = super.buildWebPanelContext(location);
        if (this.resultsSummary != null) {
            map.put("resultSummary", this.resultsSummary);
        }
        return map;
    }

    protected boolean validateResultSummary() {
        if (this.getResultsSummary() == null) {
            this.addActionError(this.getText("planResult.error.summary.number.invalid", Lists.newArrayList((Object[])new Serializable[]{this.getBuildNumber(), this.getPlanKey()})));
            return false;
        }
        return true;
    }

    public int getSkippedCommitsCount(@NotNull ResultsSummary resultsSummary) {
        int result = 0;
        for (RepositoryChangeset repositoryChangeset : resultsSummary.getRepositoryChangesets()) {
            result = (int)((long)result + repositoryChangeset.getSkippedCommitsCount());
        }
        return result;
    }

    public VcsRepositoryData getRepositoryData(@NotNull RepositoryChangeset repositoryChangeset) {
        return this.repositoryDefinitionManager.entityToVcsData(repositoryChangeset.getRepositoryData());
    }

    @Nullable
    public VcsRepositoryViewer getRepositoryViewer(@NotNull VcsRepositoryData repositoryData) {
        return this.vcsRepositoryViewerManager.getViewerForRepository(repositoryData);
    }

    @NotNull
    public Map<String, String> getUrlsForChangeset(@NotNull RepositoryChangeset repositoryChangeset) {
        VcsRepositoryData repositoryData = this.getRepositoryData(repositoryChangeset);
        VcsRepositoryViewer viewer = this.getRepositoryViewer(repositoryData);
        if (viewer != null) {
            VariableSubstitutor variableSubstitutor = this.customVariableContext.getVariableSubstitutorFactory().newSubstitutorForPlan(this.getImmutablePlan());
            Stream<String> revisionStream = repositoryChangeset.getCommits().stream().map(CommitContext::guessChangeSetId).filter(StringUtils::isNotBlank);
            return (Map)this.customVariableContext.withVariableSubstitutor(variableSubstitutor, () -> viewer.getWebRepositoryUrlForRevisions(revisionStream, repositoryData));
        }
        return Collections.emptyMap();
    }

    @Nullable
    public String getUrlForCommitId(@Nullable String commitId, @NotNull VcsRepositoryData repositoryData) {
        if (StringUtils.isBlank((CharSequence)commitId)) {
            return null;
        }
        VcsRepositoryViewer viewer = this.getRepositoryViewer(repositoryData);
        if (viewer != null) {
            VariableSubstitutor variableSubstitutor = this.customVariableContext.getVariableSubstitutorFactory().newSubstitutorForPlan(this.getImmutablePlan());
            return (String)this.customVariableContext.withVariableSubstitutor(variableSubstitutor, () -> viewer.getWebRepositoryUrlForRevision(commitId, repositoryData));
        }
        return null;
    }

    public ImmutableList<RepositoryChangeset> getRepositoryChangesetsWithNotBlankRevision(@NotNull ResultsSummary resultsSummary) {
        return ImmutableList.copyOf((Collection)resultsSummary.getRepositoryChangesets().stream().filter(changeset -> StringUtils.isNotBlank((CharSequence)changeset.getChangesetId())).collect(Collectors.toList()));
    }

    public void setCreateIssueAppLinkId(String createIssueAppLinkId) {
        this.createIssueAppLinkId = createIssueAppLinkId;
    }

    public String getCreateIssueAppLinkId() {
        return this.createIssueAppLinkId;
    }

    public String getNewIssueKey() {
        return this.newIssueKey;
    }

    public void setNewIssueKey(String newIssueKey) {
        this.newIssueKey = newIssueKey;
    }

    public Map<String, String> getMaskedMetadata() {
        HashMap<String, String> maskedMetadata = new HashMap<String, String>();
        for (Map.Entry entry : this.resultsSummary.getCustomBuildData().entrySet()) {
            String value = PasswordMaskingUtils.shouldBeMasked((String)((String)entry.getKey())) ? "********" : (String)entry.getValue();
            maskedMetadata.put((String)entry.getKey(), value);
        }
        return maskedMetadata;
    }

    public List<VariableDefinitionContext> getMaskedVariables() {
        List maskedVariables = this.resultsSummary instanceof ChainResultsSummary ? this.resultsSummaryVariableAccessor.getManualVariables((ChainResultsSummary)this.resultsSummary) : this.resultsSummaryVariableAccessor.getVariableStateForJobResult((BuildResultsSummary)this.resultsSummary);
        for (int i = 0; i < maskedVariables.size(); ++i) {
            VariableDefinitionContext variable = (VariableDefinitionContext)maskedVariables.get(i);
            if (!PasswordMaskingUtils.shouldBeMasked((String)variable.getKey())) continue;
            maskedVariables.set(i, new VariableDefinitionContextImpl(variable.getKey(), "********", variable.getVariableType()));
        }
        return maskedVariables;
    }

    @NotNull
    public List<VariableDefinitionContext> getManualVariables() {
        if (this.resultsSummary instanceof ChainResultsSummary) {
            List maskedVariables = this.resultsSummaryVariableAccessor.getManualVariables((ChainResultsSummary)this.resultsSummary);
            for (int i = 0; i < maskedVariables.size(); ++i) {
                VariableDefinitionContext variable = (VariableDefinitionContext)maskedVariables.get(i);
                if (!PasswordMaskingUtils.shouldBeMasked((String)variable.getKey())) continue;
                maskedVariables.set(i, new VariableDefinitionContextImpl(variable.getKey(), "********", variable.getVariableType()));
            }
            return maskedVariables;
        }
        return Collections.emptyList();
    }

    public boolean isTestQuarantineEnabled() {
        return ((QuarantineConfiguration)this.quarantineConfiguration.get()).isEnabled();
    }

    public boolean isTestQuarantineExpiryOverridable() {
        return ((QuarantineConfiguration)this.quarantineConfiguration.get()).isExpiryOverridable();
    }

    public int getTestQuarantineExpiryDuration() {
        Period expiryPeriod = ((QuarantineConfiguration)this.quarantineConfiguration.get()).getExpiryPeriod();
        if (expiryPeriod.getMonths() != 0) {
            return expiryPeriod.getMonths();
        }
        if (expiryPeriod.getWeeks() != 0) {
            return expiryPeriod.getWeeks();
        }
        return expiryPeriod.getDays();
    }

    public String getTestQuarantineExpiryPeriod() {
        Period expiryPeriod = ((QuarantineConfiguration)this.quarantineConfiguration.get()).getExpiryPeriod();
        if (expiryPeriod.getMonths() != 0) {
            return "months";
        }
        if (expiryPeriod.getWeeks() != 0) {
            return "weeks";
        }
        return "days";
    }

    @Nullable
    public final String getArtifactLinkUrl(ArtifactLink artifactLink) {
        return ArtifactHandlingUtils.getArtifactUrl((ArtifactLinkManager)this.artifactLinkManager, (Artifact)artifactLink.getArtifact(), (String)this.getBambooUrl().rootContext());
    }

    @NotNull
    public final String getArtifactSizeDescription(ArtifactLink artifactLink) {
        return FileUtils.byteCountToDisplaySize((long)artifactLink.getArtifact().getSize());
    }

    public boolean isChain() {
        return this.resultsSummary instanceof ChainResultsSummary;
    }

    public void setArtifactLinkManager(ArtifactLinkManager artifactLinkManager) {
        this.artifactLinkManager = artifactLinkManager;
    }

    @Override
    public void setRepositoryDefinitionManager(RepositoryDefinitionManager repositoryDefinitionManager) {
        this.repositoryDefinitionManager = repositoryDefinitionManager;
    }

    public void setVcsRepositoryViewerManager(VcsRepositoryViewerManager vcsRepositoryViewerManager) {
        this.vcsRepositoryViewerManager = vcsRepositoryViewerManager;
    }

    public void setCustomVariableContext(CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }

    public void setCommentManager(CommentManager commentManager) {
        this.commentManager = commentManager;
    }

    public void setResultsSummaryVariableAccessor(ResultsSummaryVariableAccessor resultsSummaryVariableAccessor) {
        this.resultsSummaryVariableAccessor = resultsSummaryVariableAccessor;
    }
}

