/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.build.PlanDependency;
import com.atlassian.bamboo.build.PlanDependencyDao;
import com.atlassian.bamboo.build.PlanDependencyImpl;
import com.atlassian.bamboo.build.PlanDependencyManager;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.exception.AccessDeniedException;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.branch.BranchSpecificConfiguration;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableChainBranch;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.security.BambooCachingPermissionManagerFacade;
import com.atlassian.bamboo.security.BambooCachingPermissionManagerFacadeFactory;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.BambooPredicates;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.core.bean.EntityObject;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Lazy;

public class PlanDependencyManagerImpl
implements PlanDependencyManager {
    private static final Logger log = Logger.getLogger(PlanDependencyManagerImpl.class);
    private final PlanDependencyDao planDependencyDao;
    private final PlanManager planManager;
    @Lazy
    @Inject
    private CachedPlanManager cachedPlanManager;
    @Lazy
    @Inject
    private BambooCachingPermissionManagerFacadeFactory bambooCachingPermissionManagerFacadeFactory;

    @Inject
    public PlanDependencyManagerImpl(PlanDependencyDao planDependencyDao, PlanManager planManager) {
        this.planDependencyDao = planDependencyDao;
        this.planManager = planManager;
    }

    @NotNull
    public Set<PlanDependency> getAllDependencies() {
        return new HashSet<PlanDependency>(this.planDependencyDao.findAllDependencies());
    }

    @NotNull
    public Set<PlanDependency> getChildPlanDependencies(@NotNull PlanIdentifier plan) {
        return new HashSet<PlanDependency>(this.planDependencyDao.getChildPlanDependencies(plan));
    }

    @NotNull
    public Set<String> getParentChainKeys(@NotNull PlanIdentifier plan) {
        return this.toParentKeys(this.getParentPlanDependencies(plan).stream().filter(arg_0 -> ((Predicate)BambooPredicates.dependencyParentIsChain()).apply(arg_0)));
    }

    @NotNull
    public Set<String> getChildChainKeys(@NotNull PlanIdentifier plan) {
        return this.toChildKeys(this.getChildPlanDependencies(plan).stream().filter(arg_0 -> ((Predicate)BambooPredicates.dependencyChildIsChain()).apply(arg_0)));
    }

    @NotNull
    public Set<String> getNotEditableChildKeys(@NotNull PlanIdentifier plan) {
        return this.toChildKeys(this.planDependencyDao.getChildNonEditableDependencies(plan).stream());
    }

    @NotNull
    public Set<String> getNotEditableParentKeys(@NotNull PlanIdentifier plan) {
        return this.toParentKeys(this.planDependencyDao.getParentNonEditableDependencies(plan).stream());
    }

    @NotNull
    public Set<PlanDependency> getParentPlanDependencies(@NotNull PlanIdentifier plan) {
        return Sets.newHashSet((Iterable)this.planDependencyDao.getParentPlanDependencies(plan));
    }

    public void removeAllDependenciesForPlan(@NotNull PlanIdentifier plan) {
        this.planDependencyDao.removeDependenciesForPlan(plan);
    }

    @NotNull
    public Set<String> getChildPlanKeys(@NotNull PlanIdentifier plan) {
        return this.toChildKeys(this.getChildPlanDependencies(plan).stream());
    }

    @NotNull
    public Set<String> getParentPlanKeys(@NotNull PlanIdentifier plan) {
        return this.toParentKeys(this.planDependencyDao.getParentPlanDependencies(plan).stream());
    }

    @NotNull
    public ErrorCollection validateChildDependencyList(@NotNull String dependencyType, @NotNull Plan plan, @NotNull Set<PlanKey> newChildPlanKeys, boolean overwriteExisting) {
        SimpleErrorCollection result = new SimpleErrorCollection();
        BambooCachingPermissionManagerFacade permissionManager = this.bambooCachingPermissionManagerFacadeFactory.create();
        if (!this.hasBuildPermissionToAllChildPlans(permissionManager, newChildPlanKeys)) {
            result.addErrorMessage(BambooPermission.BUILD.getName() + " permission is required for all child plans.");
        }
        return result;
    }

    public void adjustChildDependencyList(@NotNull String dependencyType, @NotNull Plan plan, @NotNull Set<PlanKey> newChildPlanKeys, boolean overwriteExisting) {
        BambooCachingPermissionManagerFacade permissionManager = this.bambooCachingPermissionManagerFacadeFactory.create();
        if (!this.hasBuildPermissionToAllChildPlans(permissionManager, newChildPlanKeys)) {
            throw new AccessDeniedException(BambooPermission.BUILD.getName() + " permission is required for all child plans.");
        }
        HashSet planKeysToLinkAsChildren = Sets.newHashSet(newChildPlanKeys);
        Set<PlanDependency> currentChildren = this.getChildPlanDependencies((PlanIdentifier)plan);
        for (PlanDependency planDependency : currentChildren) {
            Plan childPlan2 = planDependency.getChildPlan();
            if (childPlan2 == null) continue;
            PlanKey childPlanKey = childPlan2.getPlanKey();
            if (newChildPlanKeys.contains(childPlanKey)) {
                if (overwriteExisting && !dependencyType.equals(planDependency.getDependencyType())) {
                    this.planDependencyDao.remove((EntityObject)((PlanDependencyImpl)planDependency));
                    continue;
                }
                planKeysToLinkAsChildren.remove(childPlanKey);
                continue;
            }
            if (!dependencyType.equals(planDependency.getDependencyType())) continue;
            this.planDependencyDao.remove((EntityObject)((PlanDependencyImpl)planDependency));
        }
        planKeysToLinkAsChildren.stream().map(arg_0 -> ((PlanManager)this.planManager).getPlanByKey(arg_0)).map(childPlan -> new PlanDependencyImpl(dependencyType, plan, childPlan)).forEach(this::savePlanDependency);
    }

    public void adjustParentDependencyList(@NotNull String dependencyKey, @NotNull Plan childPlan, @NotNull Set<PlanKey> newParentPlanKeys, boolean overwriteExisting) {
        HashSet planKeysToLinkAsParents = Sets.newHashSet(newParentPlanKeys);
        Set<PlanDependency> currentParents = this.getParentPlanDependencies((PlanIdentifier)childPlan);
        for (PlanDependency planDependency : currentParents) {
            Plan parentPlan = planDependency.getParentPlan();
            if (parentPlan == null) continue;
            PlanKey parentPlanKey = parentPlan.getPlanKey();
            if (newParentPlanKeys.contains(parentPlanKey)) {
                if (overwriteExisting && !dependencyKey.equals(planDependency.getDependencyType())) {
                    this.planDependencyDao.remove((EntityObject)planDependency);
                    continue;
                }
                planKeysToLinkAsParents.remove(parentPlanKey);
                continue;
            }
            if (!dependencyKey.equals(planDependency.getDependencyType())) continue;
            this.planDependencyDao.remove((EntityObject)planDependency);
        }
        for (PlanKey parentPlanKey : planKeysToLinkAsParents) {
            this.savePlanDependency((PlanDependency)new PlanDependencyImpl(dependencyKey, this.planManager.getPlanByKey(parentPlanKey), childPlan));
        }
    }

    public boolean savePlanDependency(@Nullable PlanDependency dependency) {
        if (dependency == null) {
            log.warn((Object)"Cannot save null plan dependency");
            return false;
        }
        Plan child = dependency.getChildPlan();
        Plan parent = dependency.getParentPlan();
        if (child == null) {
            log.warn((Object)("Cannot save plan dependency, the child is null. " + dependency.toString()));
            return false;
        }
        if (parent == null) {
            log.warn((Object)("Cannot save plan dependency, the parent is null. " + dependency.toString()));
            return false;
        }
        if (child.equals(parent)) {
            log.warn((Object)("Cannot save plan dependency, the child is the same as the parent. " + dependency.toString()));
            return false;
        }
        if (this.getAllDependencies().contains(dependency)) {
            log.warn((Object)("Cannot save plan dependency, it already exists in the database. " + dependency.toString()));
            return false;
        }
        this.planDependencyDao.save((EntityObject)((PlanDependencyImpl)dependency));
        return true;
    }

    private boolean hasBuildPermissionToAllChildPlans(BambooCachingPermissionManagerFacade permissionManager, Set<PlanKey> childPlanKeys) {
        return childPlanKeys.stream().allMatch(childPlanKey -> {
            try {
                return permissionManager.hasPlanPermission(BambooPermission.BUILD, childPlanKey);
            }
            catch (Exception e) {
                log.debug((Object)e.getMessage());
                return false;
            }
        });
    }

    private boolean isBranchDependencyTriggeringOn(@NotNull ImmutablePlan masterPlan) {
        Map configuration = masterPlan.getBuildDefinition().getCustomConfiguration();
        String value = (String)configuration.get("custom.dependencies.triggerForBranches");
        return Boolean.parseBoolean(value);
    }

    public Set<ImmutablePlan> getEffectiveChildPlans(@NotNull ImmutablePlan chain) {
        if (chain.hasMaster()) {
            BranchSpecificConfiguration bsc = chain.getBuildDefinition().getBranchSpecificConfiguration();
            if (bsc.isValid() && this.isBranchDependencyTriggeringOn(chain.getMaster())) {
                return this.getChildBranches(chain);
            }
            log.info((Object)"Dependant builds not checked since plan is not a master plan and branch dependencies are switched off");
            return Collections.emptySet();
        }
        return this.getChildPlanDependencies((PlanIdentifier)chain).stream().map(PlanDependency::getChildPlan).collect(Collectors.toSet());
    }

    public Set<ImmutablePlan> getEffectiveParentPlans(@NotNull ImmutablePlan chain) {
        if (chain.hasMaster()) {
            return this.getParentBranches(chain);
        }
        return this.getParentPlanDependencies((PlanIdentifier)chain).stream().map(PlanDependency::getParentPlan).filter(Objects::nonNull).collect(Collectors.toCollection(HashSet::new));
    }

    private Set<ImmutablePlan> getParentBranches(ImmutablePlan childBranch) {
        HashSet<ImmutablePlan> parentBranches = new HashSet<ImmutablePlan>();
        String branchName = childBranch.getBuildName();
        ImmutablePlan master = childBranch.getMaster();
        Set<PlanDependency> masterDependencies = this.getParentPlanDependencies((PlanIdentifier)master);
        for (PlanDependency planDependency : masterDependencies) {
            ImmutableChainBranch dependantBranch;
            Chain parentChain = (Chain)Narrow.downTo((Object)planDependency.getParentPlan(), Chain.class);
            if (parentChain == null || !this.isBranchDependencyTriggeringOn((ImmutablePlan)parentChain) || (dependantBranch = this.getBranchWithName((ImmutableChain)parentChain, branchName)) == null) continue;
            parentBranches.add((ImmutablePlan)dependantBranch);
        }
        return parentBranches;
    }

    @Nullable
    private ImmutableChainBranch getBranchWithName(ImmutableChain chain, String branchName) {
        for (ImmutableChainBranch immutableChainBranch : this.cachedPlanManager.getBranchesForChain((PlanIdentifier)chain)) {
            if (!immutableChainBranch.getBuildName().equals(branchName)) continue;
            return immutableChainBranch;
        }
        return null;
    }

    private Set<ImmutablePlan> getChildBranches(ImmutablePlan parentBranch) {
        HashSet<ImmutablePlan> childBranches = new HashSet<ImmutablePlan>();
        String branchName = parentBranch.getBuildName();
        ImmutablePlan master = parentBranch.getMaster();
        Set<PlanDependency> masterDependencies = this.getChildPlanDependencies((PlanIdentifier)master);
        for (PlanDependency planDependency : masterDependencies) {
            ImmutableChainBranch dependantBranch;
            Chain childChain = (Chain)Narrow.downTo((Object)planDependency.getChildPlan(), Chain.class);
            if (childChain == null || (dependantBranch = this.getBranchWithName((ImmutableChain)childChain, branchName)) == null) continue;
            childBranches.add((ImmutablePlan)dependantBranch);
        }
        return childBranches;
    }

    @Nullable
    private String toParentKey(@NotNull PlanDependency planDep) {
        Plan parentPlan = planDep.getParentPlan();
        if (parentPlan == null) {
            return null;
        }
        return parentPlan.getKey();
    }

    @Nullable
    private String toChildKey(PlanDependency planDep) {
        Plan childPlan = planDep.getChildPlan();
        if (childPlan == null) {
            return null;
        }
        return childPlan.getKey();
    }

    @NotNull
    private Set<String> toParentKeys(Stream<PlanDependency> dependencies) {
        return dependencies.map(this::toParentKey).filter(Objects::nonNull).collect(Collectors.toCollection(HashSet::new));
    }

    @NotNull
    private Set<String> toChildKeys(@NotNull Stream<PlanDependency> dependencies) {
        return dependencies.map(this::toChildKey).filter(Objects::nonNull).collect(Collectors.toCollection(HashSet::new));
    }
}

