/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.build.PlanResultsAction;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultSummaryHelper;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.util.UrlUtils;
import org.apache.log4j.Logger;

public class GotoBuildResult
extends PlanResultsAction {
    private static final Logger log = Logger.getLogger(GotoBuildResult.class);

    public String execute() throws Exception {
        return "success";
    }

    @Override
    public String getReturnUrl() {
        this.forceRelativeReturnUrl();
        String originalReturnUrl = super.getReturnUrl();
        ImmutablePlan immutablePlan = this.getImmutablePlan();
        if (immutablePlan == null && PlanKeys.isJobKey((PlanKey)this.getTypedPlanKey())) {
            immutablePlan = this.cachedPlanManager.getPlanByKey(PlanKeys.getChainKeyFromJobKey((PlanKey)this.getTypedPlanKey()));
        }
        if (immutablePlan == null || this.getBuildNumber() == null) {
            return originalReturnUrl;
        }
        ImmutableChain parent = immutablePlan instanceof ImmutableJob ? ((ImmutableJob)immutablePlan).getParent() : (ImmutableChain)immutablePlan;
        try {
            int lastBuildNumber = parent.getLastBuildNumber();
            int firstBuildNumber = parent.getFirstBuildNumber();
            int intBuildNumber = Math.max(firstBuildNumber, Math.min(lastBuildNumber, this.getRequestedBuildNumber()));
            ChainResultsSummary chainResultSummary = this.getChainResultSummary(immutablePlan, intBuildNumber);
            if (chainResultSummary != null && this.needToRedirectToChainResult(immutablePlan, PlanKeys.getPlanResultKey((PlanKey)immutablePlan.getPlanKey(), (int)intBuildNumber), chainResultSummary)) {
                PlanResultKey resultKey = this.getChainResultKey(immutablePlan, intBuildNumber);
                String url = "/browse/" + resultKey.getKey();
                if (originalReturnUrl.endsWith("/log")) {
                    return url + "/log";
                }
                if (originalReturnUrl.endsWith("/commit")) {
                    return url + "/commit";
                }
                return url;
            }
            if (originalReturnUrl.toLowerCase().contains("buildnumber=")) {
                return UrlUtils.replaceOrInsertParamValue((String)originalReturnUrl, (String)Integer.toString(intBuildNumber));
            }
            return UrlUtils.replacePlanResultKeyInUrl((String)originalReturnUrl, (PlanKey)this.getTypedPlanKey(), (int)intBuildNumber);
        }
        catch (NumberFormatException e) {
            return originalReturnUrl;
        }
    }

    private boolean needToRedirectToChainResult(ImmutablePlan immutablePlan, PlanResultKey resultKey, ChainResultsSummary chainResultSummary) {
        if (ResultSummaryHelper.isBambooSpecResult((ImmutableResultsSummary)chainResultSummary)) {
            return true;
        }
        return PlanKeys.isJobKey((PlanKey)resultKey.getPlanKey()) && this.resultsSummaryManager.getResultsSummary(resultKey) == null;
    }

    private PlanResultKey getChainResultKey(ImmutablePlan immutablePlan, int buildNumber) {
        if (immutablePlan instanceof ImmutableJob) {
            return PlanKeys.getPlanResultKey((PlanKey)PlanKeys.getChainKeyIfJobKey((PlanKey)immutablePlan.getPlanKey()), (int)buildNumber);
        }
        return PlanKeys.getPlanResultKey((PlanKey)immutablePlan.getPlanKey(), (int)buildNumber);
    }

    private ChainResultsSummary getChainResultSummary(ImmutablePlan immutablePlan, int buildNumber) {
        return (ChainResultsSummary)Narrow.downTo((Object)this.resultsSummaryManager.getResultsSummary(this.getChainResultKey(immutablePlan, buildNumber)), ChainResultsSummary.class);
    }
}

