/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.build.CookieCutterImpl;
import java.util.Map;
import org.apache.commons.collections4.map.ListOrderedMap;
import org.apache.log4j.Logger;

public class FilterController
extends CookieCutterImpl {
    private static final Logger log = Logger.getLogger(FilterController.class);
    public static final String FILTER_COOKIE_NAME = "BAMBOO-BUILD-FILTER";
    public static final String AGENT_FILTER_COOKIE_NAME = "BAMBOO-AGENT-FILTER";
    private static final String KEY_LAST_7_DAYS = "LAST_7_DAYS";
    private static final String KEY_LAST_30_DAYS = "LAST_30_DAYS";
    private static final String KEY_LAST_90_DAYS = "LAST_90_DAYS";
    private static final String KEY_ALL_BUILDS = "ALL_BUILDS";
    private static final String KEY_LAST_25_BUILDS = "LAST_25_BUILDS";
    private static final String LABEL_LAST_7_DAYS = "Last 7 days";
    private static final String LABEL_LAST_30_DAYS = "Last 30 days";
    private static final String LABEL_LAST_90_DAYS = "Last 90 days";
    private static final String LABEL_ALL_BUILDS = "All builds";
    private static final String LABEL_LAST_25_BUILDS = "Last 25 builds";
    private Map<String, String> filterMap;

    public Map<String, String> getFilterMap() {
        if (this.filterMap == null) {
            this.filterMap = new ListOrderedMap();
            this.filterMap.put(KEY_LAST_25_BUILDS, LABEL_LAST_25_BUILDS);
            this.filterMap.put(KEY_LAST_7_DAYS, LABEL_LAST_7_DAYS);
            this.filterMap.put(KEY_LAST_30_DAYS, LABEL_LAST_30_DAYS);
            this.filterMap.put(KEY_LAST_90_DAYS, LABEL_LAST_90_DAYS);
            this.filterMap.put(KEY_ALL_BUILDS, LABEL_ALL_BUILDS);
        }
        return this.filterMap;
    }

    private String getFilterKey(String cookieKey) {
        String key = this.getValueFromCookie(cookieKey);
        if (key != null && this.getFilterMap().containsKey(key)) {
            return key;
        }
        this.saveValueInCookie(cookieKey, KEY_LAST_25_BUILDS);
        return KEY_LAST_25_BUILDS;
    }

    public String getSelectedFilterName() {
        return this.getFilterMap().get(this.getSelectedFilterKey());
    }

    public String getSelectedFilterKey() {
        return this.getFilterKey(FILTER_COOKIE_NAME);
    }

    public void setSelectedFilterKey(String selectedFilterKey) {
        this.saveValueInCookie(FILTER_COOKIE_NAME, selectedFilterKey);
    }

    public String getAgentFilterName() {
        return this.getFilterMap().get(this.getAgentFilterKey());
    }

    public String getAgentFilterKey() {
        return this.getFilterKey(AGENT_FILTER_COOKIE_NAME);
    }

    public void setAgentFilterKey(String agentFilterKey) {
        this.saveValueInCookie(AGENT_FILTER_COOKIE_NAME, agentFilterKey);
    }
}

