/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.build.CookieCutter;
import com.atlassian.bamboo.util.RequestCacheThreadLocal;
import com.atlassian.seraph.config.SecurityConfigFactory;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CookieCutterImpl
implements CookieCutter {
    public static int FILTER_COOKIE_AGE = 31536000;
    private static final Logger log = Logger.getLogger(CookieCutterImpl.class);
    private static final int MAX_ALLOWED_COOKIE_LENGTH = 4000;
    private static final int DESIRED_CONGLOMERATE_COOKIE_LENGTH = 3000;
    private static final Pattern COOKIE_REPAIR_PATTERN = Pattern.compile("\\|\\|+");
    public static final String AJS_CONGLOMERATE_COOKIE = "AJS.conglomerate.cookie";

    @Override
    public void saveValueInCookie(String key, String value) {
        CookieCutterImpl.saveValueInCookie(key, value, null);
    }

    private static void saveValueInCookie(String key, String value, @Nullable String path) {
        HttpServletRequest request = RequestCacheThreadLocal.getNonNullRequest();
        HttpServletResponse response = RequestCacheThreadLocal.getNonNullResponse();
        if (path == null) {
            path = CookieCutterImpl.getCookiePath(request);
        }
        CookieCutterImpl.setCookie(request, response, key, value, FILTER_COOKIE_AGE, path);
    }

    @Override
    @NotNull
    public String getValueFromCookie(String key) {
        String cookieValue = CookieCutterImpl.getCookieValue(RequestCacheThreadLocal.getNonNullRequest(), key);
        if (cookieValue == null) {
            return "";
        }
        cookieValue = StringUtils.removeStart((String)cookieValue, (String)"\"");
        cookieValue = StringUtils.removeStart((String)cookieValue, (String)"'");
        cookieValue = StringUtils.removeEnd((String)cookieValue, (String)"\"");
        cookieValue = StringUtils.removeEnd((String)cookieValue, (String)"'");
        return cookieValue;
    }

    @Override
    public String getValueFromCookie(String key, String defaultValue) {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.getValueFromCookie(key), (CharSequence)defaultValue);
    }

    @Nullable
    private static String getCookieValue(HttpServletRequest request, String name) {
        log.debug((Object)("Looking for a cookie named : '" + name + "'"));
        Cookie[] cookies = request.getCookies();
        if (cookies == null || StringUtils.isEmpty((CharSequence)name)) {
            if (cookies == null) {
                log.debug((Object)"The Cookies array in the HTTP request is null");
            }
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(name)) continue;
            return cookie.getValue();
        }
        log.debug((Object)("No cookie was found with name :" + name));
        return null;
    }

    private static void setCookie(HttpServletRequest request, HttpServletResponse response, String name, String value, int maxAge, String path) {
        boolean isInSecureCookie = SecurityConfigFactory.getInstance().isInsecureCookie();
        if (log.isDebugEnabled()) {
            log.debug((Object)("setCookie " + name + ":" + value + " path : " + path + " maxAge : " + maxAge + (isInSecureCookie ? " insecure" : " secure")));
        }
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(maxAge);
        cookie.setPath(path);
        if (!isInSecureCookie) {
            cookie.setSecure(request.isSecure());
        }
        response.addCookie(cookie);
    }

    static boolean isBroken(@Nullable String header) {
        if (header == null) {
            return false;
        }
        int pos = header.indexOf(AJS_CONGLOMERATE_COOKIE);
        if (pos == -1) {
            return false;
        }
        String conglomerate = header.substring(pos);
        return StringUtils.countMatches((CharSequence)conglomerate, (CharSequence)"\"") % 2 != 0;
    }

    @Override
    @Nullable
    public String getValueFromConglomerateCookie(String cookieKey, String key) {
        String cookieContent = this.getValueFromCookie(cookieKey);
        String matchingSubCookie = null;
        String keyMatch = key + "=";
        List subCookies = Splitter.on((char)'|').splitToList((CharSequence)cookieContent);
        for (String subCookie : subCookies) {
            if (!subCookie.startsWith(keyMatch)) continue;
            matchingSubCookie = subCookie;
        }
        CookieCutterImpl.trimConglomerateCookie(cookieKey, cookieContent);
        return CookieCutterImpl.urlDecode(StringUtils.substringAfter(matchingSubCookie, (String)keyMatch));
    }

    @Nullable
    private static String urlDecode(String value) {
        if (value == null) {
            return null;
        }
        try {
            return URLDecoder.decode(value, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static void trimConglomerateCookie(String cookieKey, String originalCookieContent) {
        String repairedCookieContent = COOKIE_REPAIR_PATTERN.matcher(originalCookieContent).replaceAll("|");
        int cookieOverflowLength = repairedCookieContent.length() - 3000;
        if (cookieOverflowLength > 0) {
            String trimmedValue = CookieCutterImpl.getTrimmedValue(repairedCookieContent, cookieOverflowLength);
            CookieCutterImpl.saveValueInCookie(cookieKey, trimmedValue, "/");
        } else if (repairedCookieContent.length() != originalCookieContent.length()) {
            CookieCutterImpl.saveValueInCookie(cookieKey, repairedCookieContent, "/");
        }
    }

    static String getTrimmedValue(String repairedCookieContent, int cookieOverflowLength) {
        int trimEnd = repairedCookieContent.substring(cookieOverflowLength).indexOf(124);
        String trimmedValue = trimEnd != -1 ? repairedCookieContent.substring(cookieOverflowLength + trimEnd) : "";
        int quotesInUntrimmed = StringUtils.countMatches((CharSequence)repairedCookieContent, (CharSequence)"\"");
        int quotesInTrimmed = StringUtils.countMatches((CharSequence)trimmedValue, (CharSequence)"\"");
        if (quotesInTrimmed % 2 != quotesInUntrimmed % 2) {
            trimmedValue = "\"" + trimmedValue;
        }
        return trimmedValue;
    }

    private static String getCookiePath(HttpServletRequest request) {
        String path = request.getContextPath();
        if (StringUtils.isEmpty((CharSequence)path)) {
            return "/";
        }
        return path.startsWith("/") ? path : "/" + path;
    }
}

