/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.build.BuildExecutionManager;
import com.atlassian.bamboo.build.PlanResultsAction;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.StageStatusHelper;
import com.atlassian.bamboo.chains.cache.ImmutableChainStage;
import com.atlassian.bamboo.logger.ErrorAccessor;
import com.atlassian.bamboo.plan.ExecutionStatus;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResult;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.CurrentlyBuilding;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.queue.BuildQueueManager;
import com.atlassian.bamboo.ww2.actions.ChainAwareContextHolder;
import com.atlassian.bamboo.ww2.aware.ChainAware;
import com.google.common.base.MoreObjects;
import io.atlassian.util.concurrent.Lazy;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ChainResultsAction
extends PlanResultsAction
implements ChainAware {
    private static final Logger log = Logger.getLogger(ChainResultsAction.class);
    private final ChainAwareContextHolder chainAwareContextHolder = new ChainAwareContextHolder();
    private BuildExecutionManager buildExecutionManager;
    private ErrorAccessor decoratingAggregatedChainErrorAccessor;
    protected StageStatusHelper stageStatusHelper;
    private BuildQueueManager buildQueueManager;
    private final Supplier<List<BuildAgent>> executableAgents = Lazy.supplier(() -> {
        Set agentIds = (Set)MoreObjects.firstNonNull((Object)this.buildQueueManager.getExecutorsForQueuedExecutable((ResultKey)this.getTypedPlanResultKey()), Collections.emptySet());
        return agentIds.stream().map(arg_0 -> ((AgentManager)this.agentManager).getAgent(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    });
    private final Supplier<CurrentlyBuilding> currentlyBuilding = Lazy.supplier((Supplier)new Supplier<CurrentlyBuilding>(){

        @Override
        @Nullable
        public CurrentlyBuilding get() {
            int currentResultNum = ChainResultsAction.this.getChainResultNumber();
            for (ImmutableJob immutableJob : ChainResultsAction.this.getImmutableChain().getAllJobs()) {
                PlanResultKey planResultKey = PlanKeys.getPlanResultKey((PlanKey)immutableJob.getPlanKey(), (int)currentResultNum);
                CurrentlyBuilding currentlyBuilding = ChainResultsAction.this.buildExecutionManager.getCurrentlyBuildingByPlanResultKey((ResultKey)planResultKey);
                if (currentlyBuilding == null) continue;
                return currentlyBuilding;
            }
            return null;
        }
    });

    @Override
    public ImmutableChain getImmutableChain() {
        return this.chainAwareContextHolder.getImmutableChain();
    }

    @Deprecated
    public Chain getChain() {
        return (Chain)Narrow.downTo((Object)this.getMutablePlan(), Chain.class);
    }

    @Override
    public void setChain(ImmutableChain chain) {
        this.chainAwareContextHolder.setChain(chain);
    }

    @Override
    public ImmutableChainStage getImmutableChainStage() {
        return this.chainAwareContextHolder.getImmutableChainStage();
    }

    @Override
    public void setChainStage(ImmutableChainStage chainStage) {
        this.chainAwareContextHolder.setChainStage(chainStage);
    }

    @Override
    public ChainResultsSummary getChainResult() {
        return this.chainAwareContextHolder.getChainResult();
    }

    @Override
    public void setChainResult(ChainResultsSummary chainResult) {
        this.chainAwareContextHolder.setChainResult(chainResult);
    }

    @Override
    public int getChainResultNumber() {
        return this.chainAwareContextHolder.getChainResultNumber();
    }

    @Override
    public void setChainResultNumber(int chainResultNumber) {
        this.chainAwareContextHolder.setChainResultNumber(chainResultNumber);
    }

    @Nullable
    public ExecutionStatus getExecutionStatus(PlanResultKey planResultKey) {
        return this.planExecutionManager.getExecutionStatus(planResultKey);
    }

    public StageStatusHelper getStageStatusHelper() {
        return this.stageStatusHelper;
    }

    public void setStageStatusHelper(StageStatusHelper stageStatusHelper) {
        this.stageStatusHelper = stageStatusHelper;
    }

    @Nullable
    public ResultsSummary getFailingSinceForTest(@Nullable TestCaseResult testCaseResult) {
        int failingSinceBuildNumber;
        if (testCaseResult != null && (failingSinceBuildNumber = testCaseResult.getFailingSince()) != -1) {
            return this.resultsSummaryManager.getResultsSummary(PlanKeys.getPlanResultKey((PlanKey)this.getImmutablePlan().getPlanKey(), (int)failingSinceBuildNumber), ChainResultsSummary.class);
        }
        return null;
    }

    @Nullable
    public String getFailingSinceForTestString(@Nullable ResultsSummary resultsSummary, @Nullable TestCaseResult testCaseResult) {
        int failingSinceBuildNumber;
        if (resultsSummary != null && testCaseResult != null && (failingSinceBuildNumber = testCaseResult.getFailingSince()) != -1) {
            return resultsSummary.getPlanKey() + "-" + failingSinceBuildNumber;
        }
        return null;
    }

    @Override
    public ErrorAccessor getErrorAccessor() {
        return this.decoratingAggregatedChainErrorAccessor;
    }

    public Collection<BuildAgent> getExecutableAgents() {
        return this.executableAgents.get();
    }

    public Collection<ElasticImageConfiguration> getExecutableElasticImages() {
        Collection imagesForQueuedExecutable = this.buildQueueManager.getImagesForQueuedExecutable((ResultKey)this.getTypedPlanResultKey());
        return (Collection)MoreObjects.firstNonNull((Object)imagesForQueuedExecutable, Collections.emptyList());
    }

    public void setDecoratingAggregatedChainErrorAccessor(ErrorAccessor errorAccessor) {
        this.decoratingAggregatedChainErrorAccessor = errorAccessor;
    }

    public void setBuildExecutionManager(BuildExecutionManager buildExecutionManager) {
        this.buildExecutionManager = buildExecutionManager;
    }

    @Nullable
    public CurrentlyBuilding getCurrentlyBuilding() {
        return this.currentlyBuilding.get();
    }

    public void setBuildQueueManager(BuildQueueManager buildQueueManager) {
        this.buildQueueManager = buildQueueManager;
    }
}

